/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.helper;

import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=SettingsDecrypterHelper.class)
public class SettingsDecrypterHelper {
    @Requirement
    private Logger logger;
    @Requirement
    private SettingsDecrypter decrypter;

    public SettingsDecryptionResult decryptAndLogProblems(Proxy proxySettings) {
        return this.decryptAndLogProblems((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxySettings));
    }

    public SettingsDecryptionResult decryptAndLogProblems(Server serverSettings) {
        return this.decryptAndLogProblems((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(serverSettings));
    }

    private SettingsDecryptionResult decryptAndLogProblems(SettingsDecryptionRequest decryptRequest) {
        SettingsDecryptionResult result = this.decrypter.decrypt(decryptRequest);
        this.logProblems(result);
        return result;
    }

    private void logProblems(SettingsDecryptionResult decryptionResult) {
        boolean hasErrors = false;
        block4: for (SettingsProblem problem : decryptionResult.getProblems()) {
            switch (problem.getSeverity()) {
                case FATAL: 
                case ERROR: {
                    this.logger.error(problem.toString());
                    hasErrors = true;
                    continue block4;
                }
                case WARNING: {
                    this.logger.warn(problem.toString());
                    continue block4;
                }
            }
            throw new IllegalStateException("unknown problem severity: " + String.valueOf(problem.getSeverity()));
        }
        if (hasErrors) {
            throw new RuntimeException("Error(s) while decrypting. See details above.");
        }
    }
}

