/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;

class RemoteArtifactRepositoryManager
implements IArtifactRepositoryManager {
    private IArtifactRepositoryManager delegate;
    private final IRepositoryIdManager loadingHelper;
    private MavenAuthenticator authenticator;

    RemoteArtifactRepositoryManager(IArtifactRepositoryManager delegate, IRepositoryIdManager loadingHelper, MavenAuthenticator authenticator) {
        this.delegate = delegate;
        this.loadingHelper = loadingHelper;
        this.authenticator = authenticator;
    }

    private URI translate(URI location) {
        return this.loadingHelper.getEffectiveLocation(location);
    }

    public void addRepository(URI location) {
        this.delegate.addRepository(this.translate(location));
    }

    public boolean contains(URI location) {
        return this.delegate.contains(this.translate(location));
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Map<String, String> destinationDescriptorProperties, Map<String, String> destinationRepositoryProperties) {
        return this.delegate.createMirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties);
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Map<String, String> destinationDescriptorProperties, Map<String, String> destinationRepositoryProperties, String downloadStatsParameters) {
        return this.delegate.createMirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties, downloadStatsParameters);
    }

    public IArtifactRepository createRepository(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
        return this.delegate.createRepository(this.translate(location), name, type, properties);
    }

    public IProvisioningAgent getAgent() {
        return this.delegate.getAgent();
    }

    public URI[] getKnownRepositories(int flags) {
        return this.delegate.getKnownRepositories(flags);
    }

    public String getRepositoryProperty(URI location, String key) {
        return this.delegate.getRepositoryProperty(this.translate(location), key);
    }

    public boolean isEnabled(URI location) {
        return this.delegate.isEnabled(this.translate(location));
    }

    public IArtifactRepository loadRepository(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        return this.accessRepository(location, uri -> this.delegate.loadRepository(uri, flags, monitor));
    }

    public IArtifactRepository loadRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        return this.accessRepository(location, uri -> this.delegate.loadRepository(uri, monitor));
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return this.delegate.query(query, monitor);
    }

    public IArtifactRepository refreshRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        return this.accessRepository(location, uri -> this.delegate.refreshRepository(uri, monitor));
    }

    public boolean removeRepository(URI location) {
        return this.delegate.removeRepository(this.translate(location));
    }

    public void setEnabled(URI location, boolean enablement) {
        this.delegate.setEnabled(this.translate(location), enablement);
    }

    public void setRepositoryProperty(URI location, String key, String value) {
        this.delegate.setRepositoryProperty(this.translate(location), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V accessRepository(URI initialUri, RepositoryCallable<V> action) throws ProvisionException {
        URI effectiveURI = this.loadingHelper.getEffectiveLocationAndPrepareLoad(initialUri);
        this.authenticator.enterLoad(effectiveURI);
        try {
            V v = action.call(effectiveURI);
            return v;
        }
        finally {
            this.authenticator.exitLoad();
        }
    }

    private static interface RepositoryCallable<V> {
        public V call(URI var1) throws ProvisionException;
    }
}

