/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.MavenRepositorySettings;

@Component(role=IRepositoryIdManager.class)
public class DefaultRepositoryIdManager
implements IRepositoryIdManager {
    @Requirement
    private MavenRepositorySettings settings;
    @Requirement
    private Logger logger;
    private static final Map<URI, String> knownMavenRepositoryIds = new ConcurrentHashMap<URI, String>();

    public void addMapping(String mavenRepositoryId, URI location) {
        if (mavenRepositoryId == null) {
            return;
        }
        URI key = DefaultRepositoryIdManager.normalize(location);
        String previousValue = knownMavenRepositoryIds.put(key, mavenRepositoryId);
        if (previousValue != null && !mavenRepositoryId.equals(previousValue)) {
            this.logger.warn("p2 repository with URL " + String.valueOf(key) + " is associated with multiple IDs; was '" + previousValue + "', now is '" + mavenRepositoryId + "'");
        }
    }

    private static URI normalize(URI location) {
        try {
            String path = location.getPath();
            if (path != null && path.endsWith("/")) {
                return new URI(location.getScheme(), location.getAuthority(), path.substring(0, path.length() - 1), location.getQuery(), location.getFragment());
            }
            return location;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getEffectiveLocation(URI location) {
        if (DefaultRepositoryIdManager.certainlyNoRemoteURL(location)) {
            return location;
        }
        MavenRepositoryLocation effectiveLocation = this.effectiveLocationFor(location, false);
        return effectiveLocation.getURL();
    }

    public URI getEffectiveLocationAndPrepareLoad(URI location) {
        if (DefaultRepositoryIdManager.certainlyNoRemoteURL(location)) {
            return location;
        }
        MavenRepositoryLocation effectiveLocation = this.effectiveLocationFor(location, true);
        return effectiveLocation.getURL();
    }

    private MavenRepositoryLocation effectiveLocationFor(URI location, boolean forLoading) {
        MavenRepositoryLocation locationWithID;
        MavenRepositoryLocation mirror;
        URI normalizedLocation = DefaultRepositoryIdManager.normalize(location);
        String id = knownMavenRepositoryIds.get(normalizedLocation);
        if (id == null) {
            id = normalizedLocation.toString();
        }
        if ((mirror = this.settings.getMirror(locationWithID = new MavenRepositoryLocation(id, normalizedLocation))) != null) {
            if (forLoading) {
                this.logger.info("Loading repository '" + id + "' from mirror '" + mirror.getId() + "' at '" + String.valueOf(mirror.getURL()) + "'");
            }
            return mirror;
        }
        return locationWithID;
    }

    private static boolean certainlyNoRemoteURL(URI location) {
        return location.isOpaque() || !location.isAbsolute();
    }

    public Stream<MavenRepositoryLocation> getKnownMavenRepositoryLocations() {
        return Stream.concat(knownMavenRepositoryIds.entrySet().stream().map(e -> new MavenRepositoryLocation((String)e.getValue(), (URI)e.getKey())), this.settings.getMirrors());
    }

    public MavenRepositorySettings getSettings() {
        return this.settings;
    }
}

