/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;
import org.eclipse.tycho.p2maven.transport.TychoRepositoryTransport;
import org.eclipse.tycho.transport.TransportProtocolHandler;

public class TychoRepositoryTransportCacheManager
extends CacheManager {
    private static final List<String> EXTENSIONS = List.of(".jar", ".xml");
    private TychoRepositoryTransport transport;

    public TychoRepositoryTransportCacheManager(TychoRepositoryTransport transport) {
        super(null, (Transport)transport);
        this.transport = transport;
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        TransportProtocolHandler handler = this.transport.getHandler(repositoryLocation);
        if (handler != null) {
            for (String extension : EXTENSIONS) {
                URI fileLocation = URIUtil.append((URI)repositoryLocation, (String)(prefix + extension));
                try {
                    File cachedFile = handler.getFile(fileLocation);
                    if (cachedFile == null) continue;
                    return cachedFile;
                }
                catch (FileNotFoundException e) {
                }
            }
            throw new FileNotFoundException("Not found any of " + String.valueOf(EXTENSIONS) + " for " + String.valueOf(repositoryLocation) + " with prefix " + prefix);
        }
        return super.createCache(repositoryLocation, prefix, monitor);
    }

    public File createCacheFromFile(URI remoteFile, IProgressMonitor monitor) throws ProvisionException, IOException {
        File cachedFile;
        TransportProtocolHandler handler = this.transport.getHandler(remoteFile);
        if (handler != null && (cachedFile = handler.getFile(remoteFile)) != null) {
            return cachedFile;
        }
        return super.createCacheFromFile(remoteFile, monitor);
    }

    protected File getCacheDirectory() {
        TransportCacheConfig config = this.transport.getCacheConfig();
        return new File(config.getCacheLocation(), "p2-repository-metadata");
    }
}

