/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.sisu.equinox.launching.BundleReference;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.osgi.framework.Version;

public class DefaultEquinoxInstallation
implements EquinoxInstallation {
    private final File location;
    private final File configurationLocation;
    private final EquinoxInstallationDescription description;

    public DefaultEquinoxInstallation(EquinoxInstallationDescription installationDescription, File location, File configurationLocation) {
        this.description = installationDescription;
        this.location = location;
        this.configurationLocation = configurationLocation;
    }

    public File getLocation() {
        return this.location;
    }

    public File getConfigurationLocation() {
        return this.configurationLocation;
    }

    public File getLauncherJar() {
        BundleReference systemBundle = this.description.getSystemBundle();
        Version osgiVersion = Version.parseVersion((String)systemBundle.getVersion());
        if (osgiVersion.compareTo(DefaultEquinoxInstallationDescription.EQUINOX_VERSION_3_3_0) < 0) {
            throw new IllegalArgumentException("Eclipse 3.2 and earlier are not supported.");
        }
        BundleReference launcher = this.description.getBundle("org.eclipse.equinox.launcher", null);
        if (launcher == null) {
            throw new IllegalArgumentException("Could not find org.eclipse.equinox.launcher bundle in the test runtime.");
        }
        try {
            return launcher.getLocation().getCanonicalFile();
        }
        catch (IOException e) {
            return launcher.getLocation().getAbsoluteFile();
        }
    }

    public EquinoxInstallationDescription getInstallationDescription() {
        return this.description;
    }
}

