/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.osgi.connect.DummyClassRealm;
import org.eclipse.sisu.osgi.connect.PlexusFrameworkConnectServiceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.connect.FrameworkUtilHelper;
import org.osgi.framework.launch.Framework;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class PlexusConnectFramework
implements Logger,
EmbeddedEquinox,
EquinoxServiceFactory,
FrameworkUtilHelper,
FrameworkListener,
LogListener,
BundleActivator {
    private final Framework framework;
    private final Logger logger;
    private final String uuid = UUID.randomUUID().toString();
    private final Map<Class<?>, ServiceTracker<?, ?>> trackerMap = new ConcurrentHashMap();
    private final ClassRealm realm;
    final PlexusFrameworkConnectServiceFactory factory;
    final boolean foreign;
    private ServiceTracker<LogReaderService, LogReaderService> logReaderServiceTracker;
    private String storagePath;

    PlexusConnectFramework(Framework framework, Logger logger, PlexusFrameworkConnectServiceFactory factory, ClassRealm realm, boolean foreign, String storagePath) {
        this.framework = framework;
        this.logger = logger;
        this.factory = factory;
        this.realm = realm;
        this.foreign = foreign;
        this.storagePath = storagePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable throwable) {
        this.logger.debug(this.format(message), throwable);
    }

    private String format(String message) {
        return String.format("[%s][%s] %s", this.getUuid(), this.realm.getId(), message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable throwable) {
        this.logger.info(this.format(message), throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable throwable) {
        this.logger.warn(this.format(message), throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable throwable) {
        this.logger.error(this.format(message), throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void fatalError(String message) {
        this.logger.fatalError(this.format(message));
    }

    public void fatalError(String message, Throwable throwable) {
        this.logger.fatalError(this.format(message), throwable);
    }

    public boolean isFatalErrorEnabled() {
        return this.logger.isFatalErrorEnabled();
    }

    public int getThreshold() {
        return this.logger.getThreshold();
    }

    public void setThreshold(int threshold) {
        this.logger.setThreshold(threshold);
    }

    public Logger getChildLogger(String name) {
        return this.logger.getChildLogger(this.format(name));
    }

    public String getName() {
        return String.format("%s (realm = %s, factory = %s)", this.uuid, this.realm.getId(), this.factory);
    }

    public EquinoxServiceFactory getServiceFactory() {
        return this;
    }

    public <T> void registerService(Class<T> clazz, T service) {
        this.registerService(clazz, service, Map.of());
    }

    public <T> void registerService(Class<T> clazz, T service, Map<String, ?> properties) {
        this.framework.getBundleContext().registerService(clazz, service, FrameworkUtil.asDictionary(properties));
    }

    public <T> T getService(Class<T> clazz) {
        return this.getService(clazz, null);
    }

    public <T> T getService(Class<T> clazz, String filter) {
        try {
            ServiceTracker serviceTracker = this.trackerMap.computeIfAbsent(clazz, cls -> {
                ServiceTracker tracker = new ServiceTracker(this.framework.getBundleContext(), cls, null);
                tracker.open(this.realm instanceof DummyClassRealm);
                return tracker;
            });
            if (filter == null) {
                Object service = serviceTracker.getService();
                return clazz.cast(service);
            }
            Filter f = this.framework.getBundleContext().createFilter(filter);
            for (Map.Entry entry : serviceTracker.getTracked().entrySet()) {
                if (!f.match((ServiceReference)entry.getKey())) continue;
                return clazz.cast(entry.getValue());
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Optional<Bundle> getBundle(Class<?> classFromBundle) {
        URI location = PlexusConnectFramework.getLocationFromClass(classFromBundle);
        if (location != null) {
            Bundle[] bundles;
            BundleContext bundleContext = this.getFramework().getBundleContext();
            if (bundleContext == null) {
                return Optional.empty();
            }
            this.debug("Searching bundle for class " + String.valueOf(classFromBundle) + " and location " + String.valueOf(location));
            for (Bundle bundle : bundles = bundleContext.getBundles()) {
                String bundleLocation = bundle.getLocation();
                if (!PlexusConnectFramework.locationsMatch(location, bundleLocation)) continue;
                this.debug("Return bundle " + bundle.getSymbolicName() + " for location " + String.valueOf(location));
                return Optional.of(bundle);
            }
            if (classFromBundle.getClassLoader() == BundleContext.class.getClassLoader()) {
                return Optional.of(bundleContext.getBundle(0L));
            }
            this.debug("No bundle matched for " + String.valueOf(location));
        }
        return Optional.empty();
    }

    static URI getLocationFromClass(Class<?> classFromBundle) {
        ProtectionDomain domain = classFromBundle.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return null;
        }
        try {
            return url.toURI().normalize();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    static boolean locationsMatch(URI location, String bundleLocation) {
        if (bundleLocation == null) {
            return false;
        }
        return location.equals(new File(bundleLocation).toURI().normalize());
    }

    public String toString() {
        return this.format(this.getClass().getSimpleName());
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (this.logger.isDebugEnabled()) {
            if (event.getType() == 2) {
                this.error(event.getBundle().getSymbolicName(), event.getThrowable());
            }
            if (event.getType() == 16) {
                this.warn(event.getBundle().getSymbolicName(), event.getThrowable());
            }
            if (event.getType() == 32) {
                this.info(event.getBundle().getSymbolicName(), event.getThrowable());
            }
        }
    }

    public void logged(LogEntry entry) {
        if (PlexusConnectFramework.isOnlyDebug(entry) && !this.logger.isDebugEnabled()) {
            return;
        }
        switch (entry.getLogLevel()) {
            case AUDIT: 
            case ERROR: {
                this.error(entry.getMessage(), entry.getException());
                break;
            }
            case WARN: {
                this.warn(entry.getMessage(), entry.getException());
                break;
            }
            case INFO: {
                this.info(entry.getMessage(), entry.getException());
                break;
            }
            case TRACE: 
            case DEBUG: {
                this.debug(entry.getMessage(), entry.getException());
            }
        }
    }

    private static boolean isOnlyDebug(LogEntry entry) {
        return entry.getException() instanceof BundleException;
    }

    public void start(final BundleContext context) {
        context.addFrameworkListener((FrameworkListener)this);
        this.logReaderServiceTracker = new ServiceTracker(context, LogReaderService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<LogReaderService, LogReaderService>(){

            public LogReaderService addingService(ServiceReference<LogReaderService> reference) {
                LogReaderService service = (LogReaderService)context.getService(reference);
                if (service != null) {
                    service.addLogListener((LogListener)PlexusConnectFramework.this);
                }
                return service;
            }

            public void modifiedService(ServiceReference<LogReaderService> reference, LogReaderService service) {
            }

            public void removedService(ServiceReference<LogReaderService> reference, LogReaderService service) {
                service.removeLogListener((LogListener)PlexusConnectFramework.this);
                context.ungetService(reference);
            }
        });
        this.logReaderServiceTracker.open();
    }

    public void stop(BundleContext context) {
        context.removeFrameworkListener((FrameworkListener)this);
        this.logReaderServiceTracker.close();
        this.trackerMap.values().forEach(ServiceTracker::close);
        this.trackerMap.clear();
    }
}

