/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.stream.Collectors;

public class ReproducibleUtils {
    private ReproducibleUtils() {
    }

    public static void storeProperties(Properties properties, Path file) throws IOException {
        Path folder = file.getParent();
        if (folder != null) {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, null);
        String content = baos.toString(StandardCharsets.ISO_8859_1).lines().filter(line -> !line.startsWith("#")).sorted().collect(Collectors.joining("\n", "", "\n"));
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            ((OutputStream)os).write(content.getBytes(StandardCharsets.ISO_8859_1));
        }
    }
}

