/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ContentsComparator.class, hint="txt")
public class TextComparator
implements ContentsComparator {
    static final String HINT = "txt";
    private static final char CR = '\r';
    private static final char LF = '\n';

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        return TextComparator.compareText(baseline, reactor, data);
    }

    public static ArtifactDelta compareText(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) {
        if (!TextComparator.isEqualTextIngoreNewLine(baseline.asBytes(), reactor.asBytes())) {
            return TextComparator.createDelta(ArtifactDelta.DEFAULT.getMessage(), baseline, reactor, data);
        }
        return ArtifactDelta.NO_DIFFERENCE;
    }

    public static boolean isEqualTextIngoreNewLine(byte[] baseline, byte[] reactor) {
        int indexBaseline = 0;
        int indexReactor = 0;
        int mismatch = Arrays.mismatch(baseline, reactor);
        while (mismatch >= 0) {
            int baselineNewLine = TextComparator.newLineLength(baseline, indexBaseline += mismatch);
            int reactorNewLine = TextComparator.newLineLength(reactor, indexReactor += mismatch);
            if (baselineNewLine < 0 || reactorNewLine < 0) {
                return false;
            }
            mismatch = Arrays.mismatch(baseline, indexBaseline += baselineNewLine, baseline.length, reactor, indexReactor += reactorNewLine, reactor.length);
        }
        return true;
    }

    private static int newLineLength(byte[] bytes, int index) {
        if (index < bytes.length) {
            if (bytes[index] == 10 && (index == 0 || bytes[index - 1] != 13)) {
                return 1;
            }
            if (bytes[index] == 13) {
                return index + 1 < bytes.length && bytes[index + 1] == 10 ? 2 : 1;
            }
        }
        return -1;
    }

    @Override
    public boolean matches(String nameOrExtension) {
        return HINT.equalsIgnoreCase(nameOrExtension);
    }

    public static ArtifactDelta createDelta(String message, ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) {
        if (data.showDiffDetails()) {
            String detailed;
            try {
                List source = IOUtils.readLines((InputStream)baseline.asNewStream(), (Charset)StandardCharsets.UTF_8);
                List target = IOUtils.readLines((InputStream)reactor.asNewStream(), (Charset)StandardCharsets.UTF_8);
                Patch patch = DiffUtils.diff((List)source, (List)target);
                List unifiedDiffList = UnifiedDiffUtils.generateUnifiedDiff((String)"baseline", (String)"reactor", (List)source, (Patch)patch, (int)0);
                detailed = unifiedDiffList.stream().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (Exception e) {
                detailed = message;
            }
            return new SimpleArtifactDelta(message, detailed, baseline.asString(StandardCharsets.UTF_8), reactor.asString(StandardCharsets.UTF_8));
        }
        return ArtifactDelta.DEFAULT;
    }
}

