/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Workspace;
import aQute.service.reporter.Report;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.bnd.MavenReactorRepository;

public abstract class AbstractBndMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(property="session", readonly=true)
    protected MavenSession session;
    @Component
    protected MavenReactorRepository mavenReactorRepository;

    protected Workspace getWorkspace() throws MojoFailureException {
        try {
            Workspace workspace = Workspace.getWorkspace((File)this.mavenProject.getBasedir().getParentFile());
            if (workspace.getPlugins().stream().noneMatch(plugin -> plugin instanceof MavenReactorRepository)) {
                workspace.addBasicPlugin((Object)this.mavenReactorRepository);
                workspace.refresh();
            }
            this.checkResult((Report)workspace, workspace.isFailOk());
            return workspace;
        }
        catch (Exception e) {
            throw new MojoFailureException("error while locating workspace!", (Throwable)e);
        }
    }

    protected void checkResult(Report report, boolean errorOk) throws MojoFailureException {
        List warnings = report.getWarnings();
        for (String warning : warnings) {
            this.getLog().warn((CharSequence)warning);
        }
        warnings.clear();
        List errors = report.getErrors();
        for (String error : errors) {
            this.getLog().error((CharSequence)error);
        }
        if (errorOk) {
            errors.clear();
            return;
        }
        if (errors.size() > 0) {
            throw new MojoFailureException(errors.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }
}

