/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bndlib.source;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.tycho.bndlib.source.SourceFile;

public class SourceCodeResolver {
    private ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
    private List<Path> sourcePathList;
    private final Map<Path, SourceFile> sourceFileMap = new ConcurrentHashMap<Path, SourceFile>();

    public SourceCodeResolver(List<Path> sourcePathList) {
        this.sourcePathList = sourcePathList;
    }

    public SourceFile getCompilationUnit(Path file) {
        return this.sourceFileMap.computeIfAbsent(file, path -> {
            String source;
            try {
                source = Files.readString(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file " + String.valueOf(path), e);
            }
            this.parser.setSource(source.toCharArray());
            ASTNode ast = this.parser.createAST(null);
            if (ast instanceof CompilationUnit) {
                CompilationUnit cu = (CompilationUnit)ast;
                return new SourceFile(cu, this);
            }
            throw new RuntimeException("Not a java file: " + String.valueOf(path));
        });
    }

    public SourceFile getCompilationUnit(String typeName) {
        String fileName = typeName.replace('.', '/') + ".java";
        for (Path source : this.sourcePathList) {
            Path candidate = source.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return this.getCompilationUnit(candidate);
        }
        return null;
    }
}

