/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.facade;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TargetPlatformResolver;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformResolverFactory;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.p2.metadata.MetadataSerializable;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.repository.registry.facade.RepositoryBlackboardKey;

@Component(role=RepositoryReferenceTool.class)
public class RepositoryReferenceTool {
    public static int REPOSITORIES_INCLUDE_CURRENT_MODULE = 1;
    @Requirement
    private EquinoxServiceFactory osgiServices;
    @Requirement
    private DefaultTargetPlatformResolverFactory targetPlatformResolverLocator;

    public RepositoryReferences getVisibleRepositories(MavenProject module, MavenSession session, int flags) throws MojoExecutionException, MojoFailureException {
        RepositoryReferences repositories = new RepositoryReferences();
        if ((flags & REPOSITORIES_INCLUDE_CURRENT_MODULE) != 0) {
            File publisherResults = new File(module.getBuild().getDirectory());
            repositories.addMetadataRepository(publisherResults);
            repositories.addArtifactRepository(publisherResults);
        }
        repositories.addArtifactRepository(RepositoryBlackboardKey.forResolutionContextArtifacts((File)module.getBasedir()));
        this.addTargetPlatformRepository(repositories, session, module);
        repositories.addArtifactRepository(new File(session.getLocalRepository().getBasedir()));
        return repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTargetPlatformRepository(RepositoryReferences sources, MavenSession session, MavenProject project) throws MojoExecutionException, MojoFailureException {
        try {
            File repositoryLocation = new File(project.getBuild().getDirectory(), "targetPlatformRepository");
            repositoryLocation.mkdirs();
            FileOutputStream stream = new FileOutputStream(new File(repositoryLocation, "content.xml"));
            try {
                MetadataSerializable serializer = (MetadataSerializable)this.osgiServices.getService(MetadataSerializable.class);
                TargetPlatform targetPlatform = TychoProjectUtils.getTargetPlatform((MavenProject)project);
                TargetPlatformResolver resolver = this.targetPlatformResolverLocator.lookupPlatformResolver(project);
                TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)project);
                DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
                DependencyArtifacts dependencyArtifacts = resolver.resolveDependencies(session, project, targetPlatform, DefaultReactorProject.adapt((MavenSession)session), resolverConfiguration);
                HashSet targetPlatformInstallableUnits = new HashSet(dependencyArtifacts.getInstallableUnits());
                for (ArtifactDescriptor artifact : dependencyArtifacts.getArtifacts()) {
                    ReactorProject otherProject = artifact.getMavenProject();
                    if (otherProject == null || !"eclipse-plugin".equals(otherProject.getPackaging()) && !"eclipse-test-plugin".equals(otherProject.getPackaging()) && !"eclipse-feature".equals(otherProject.getPackaging())) continue;
                    File artifactXml = otherProject.getArtifact("p2artifacts");
                    if (artifactXml == null || !artifactXml.isFile()) {
                        throw new MojoFailureException("Missing required file \"local-artifacts.properties\" in target folder of module " + otherProject.getId());
                    }
                    sources.addArtifactRepository(artifactXml.getParentFile());
                }
                serializer.serialize((OutputStream)stream, targetPlatformInstallableUnits);
            }
            finally {
                stream.close();
            }
            sources.addMetadataRepository(repositoryLocation);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O exception while writing the build target platform to disk", (Exception)e);
        }
    }
}

