/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.internal.repository.tools.XZCompressor;
import org.eclipse.tycho.p2tools.copiedfromp2.CategoryPublisherApplication;
import org.eclipse.tycho.plugins.p2.AbstractP2MetadataMojo;

@Mojo(name="category-p2-metadata", threadSafe=true)
public class CategoryP2MetadataMojo
extends AbstractP2MetadataMojo {
    private static final Object LOCK = new Object();
    @Parameter(defaultValue="${project.basedir}/category.xml")
    private File categoryDefinition;

    protected CategoryPublisherApplication getPublisherApplication(IProvisioningAgent agent) {
        return new CategoryPublisherApplication(agent);
    }

    @Override
    protected void addArguments(List<String> arguments) throws IOException, MalformedURLException {
        File location = this.getUpdateSiteLocation();
        arguments.add("-metadataRepository");
        arguments.add(location.toURI().toURL().toExternalForm());
        arguments.add("-categoryDefinition");
        arguments.add(this.categoryDefinition.toURI().toURL().toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            File location = this.getUpdateSiteLocation();
            File xmlFile = new File(location, "content.xml");
            File jarFile = new File(location, "content.jar");
            File xzFile = new File(location, "content.xml.xz");
            boolean jar = jarFile.isFile();
            boolean xz = xzFile.isFile();
            if (xmlFile.isFile() && jar) {
                jarFile.delete();
            }
            if (xz) {
                xzFile.delete();
            }
            super.execute();
            try {
                if (jar && xmlFile.exists()) {
                    try (JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));){
                        jarOutputStream.putNextEntry(new JarEntry(xmlFile.getName()));
                        Files.copy(xmlFile.toPath(), jarOutputStream);
                    }
                }
                if (xz) {
                    XZCompressor xzCompressor = new XZCompressor();
                    xzCompressor.setPreserveOriginalFile(true);
                    xzCompressor.setRepoFolder(location.getAbsolutePath());
                    xzCompressor.compressRepo();
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("compress content failed", (Throwable)e);
            }
        }
    }
}

