/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="fix-artifacts-metadata", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class FixArtifactsMetadataMetadataMojo
extends AbstractRepositoryMojo {
    @Parameter(defaultValue="${project.name}", property="p2.repository.name")
    private String repositoryName;
    @Parameter(defaultValue="true", property="p2.repository.xz")
    private boolean xzCompress;
    @Parameter(defaultValue="true", property="p2.repository.xz.keep")
    private boolean keepNonXzIndexFiles;
    @Component
    MirrorApplicationService mirrorApp;
    @Component
    private FileLockService fileLockService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File destination = this.getAssemblyRepositoryLocation();
        try (Closeable locking = this.fileLockService.lockVirtually(destination);){
            if (!destination.isDirectory()) {
                throw new MojoExecutionException("Could not update p2 repository, directory does not exist: " + String.valueOf(destination));
            }
            DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, true, this.xzCompress, this.keepNonXzIndexFiles, false, true);
            this.mirrorApp.recreateArtifactRepository(destinationRepoDescriptor);
        }
        catch (IOException | FacadeException e) {
            throw new MojoExecutionException("Could not update p2 repository", (Exception)e);
        }
    }
}

