/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.helper.StatusTool;
import org.eclipse.tycho.p2maven.repository.P2RepositoryKind;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;
import org.eclipse.tycho.p2maven.tools.P2RepositoryDataManipulator;

@Mojo(name="modify-composite-repository")
public class ModifyCompositeRepositoryMojo
extends AbstractMojo {
    @Parameter
    private Repository repository;
    @Parameter(property="p2.repository.output")
    private Path outputLocation;
    @Parameter(property="p2.repository.kind")
    private P2RepositoryKind repositoryKind;
    @Parameter(property="p2.repository.name")
    private String repositoryName;
    @Parameter(property="p2.composite.children.add")
    private List<URI> childrenToAdd = List.of();
    @Parameter(property="p2.composite.children.remove")
    private List<URI> childrenToRemove = List.of();
    @Parameter(property="p2.composite.children.limit", defaultValue="0")
    private int childCountLimit = 0;
    @Parameter(property="p2.composite.validate", defaultValue="true")
    private boolean validateChildren;
    @Parameter(property="p2.repository.compress", defaultValue="true")
    private boolean compress;
    @Inject
    private P2RepositoryDataManipulator manipulator;
    @Inject
    private Logger log;
    @Inject
    private P2RepositoryManager manager;
    @Inject
    private IProvisioningAgent agent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.agent.getService(Transport.class);
        try {
            Path output;
            P2RepositoryDataManipulator.ModifiedRepositoryDescriptor descriptor = P2RepositoryDataManipulator.createDescriptor((Repository)this.repository, (P2RepositoryKind)this.repositoryKind, (Path)this.outputLocation, (boolean)this.compress, (boolean)false, (boolean)false);
            Object type = "repository";
            if (this.repositoryKind != null) {
                type = (this.repositoryKind == P2RepositoryKind.artifact ? "artifact" : "metadata") + " repository";
            }
            if ((output = descriptor.outputLocation()) != null) {
                this.log.info("Write modified " + (String)type + " file(s) to " + String.valueOf(output));
            } else {
                this.log.info("Modify " + (String)type + " in-place at " + String.valueOf(descriptor.repository().getURL()));
            }
            if (this.repositoryName != null) {
                this.log.info("Set name to: " + this.repositoryName);
            }
            this.printChildren(this.childrenToRemove, "Remove");
            this.printChildren(this.childrenToAdd, "Add");
            if (this.childCountLimit > 0) {
                this.log.info("Limiting number of children to " + this.childCountLimit);
            }
            if (this.validateChildren && !this.childrenToAdd.isEmpty()) {
                for (URI child : this.childrenToAdd) {
                    this.validateChildRepository(child, descriptor);
                }
            }
            this.manipulator.modifyCompositeRepository(descriptor, this.repositoryName, this.childrenToAdd, this.childrenToRemove, this.childCountLimit);
        }
        catch (P2RepositoryDataManipulator.RepositoryLocationURISyntaxException e) {
            throw new MojoFailureException("Illegal repository location URL: " + this.repository.getUrl(), e.getCause());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to modify repository " + this.repository.getUrl(), (Exception)e);
        }
        catch (ProvisionException e) {
            this.log.error(StatusTool.toLogMessage((IStatus)e.getStatus()), (Throwable)e);
            throw new MojoExecutionException("Failed to modify repository " + this.repository.getUrl() + ": " + StatusTool.collectProblems((IStatus)e.getStatus()), (Exception)((Object)e));
        }
    }

    private void validateChildRepository(URI child, P2RepositoryDataManipulator.ModifiedRepositoryDescriptor baseRepository) throws ProvisionException {
        MavenRepositoryLocation repositoryLocation = baseRepository.repository();
        URI childLocation = repositoryLocation.getURL().resolve(child);
        this.log.info("Verifying p2 repository child at " + String.valueOf(childLocation));
        Object artifacts = "";
        Object units = "";
        if (baseRepository.isArtifact()) {
            artifacts = this.manager.allArtifacts(childLocation, repositoryLocation.getId()).stream().count() + " artifacts";
        }
        if (baseRepository.isMetadata()) {
            units = this.manager.allMetadataUnits(childLocation, repositoryLocation.getId()).stream().count() + " units";
        }
        this.log.info("  Found " + (String)artifacts + (!((String)artifacts).isEmpty() && !((String)units).isEmpty() ? " and " : "") + (String)units + ".");
    }

    private void printChildren(List<URI> children, String action) {
        if (!children.isEmpty()) {
            this.log.info(action + " children:");
            for (URI child : children) {
                this.log.info("  " + String.valueOf(child));
            }
        }
    }
}

