/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.osgiresolve;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.tycho.packaging.osgiresolve.TestModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Version;
import org.osgi.framework.connect.ConnectModule;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.resource.Resource;

public class OSGiResolver {
    private BundleContext systemContext;
    private Map<String, ConnectModule> moduleMap = new LinkedHashMap<String, ConnectModule>();
    private Equinox equinox;
    private Set<String> installedIds = new HashSet<String>();

    public OSGiResolver(File directory) throws BundleException {
        ModuleConnector moduleConnector = new ModuleConnector(){

            public Optional<BundleActivator> newBundleActivator() {
                return Optional.empty();
            }

            public void initialize(File storage, Map<String, String> configuration) {
            }

            public Optional<ConnectModule> connect(String location) throws BundleException {
                return Optional.ofNullable(OSGiResolver.this.moduleMap.get(location));
            }
        };
        this.equinox = new Equinox(Map.of("org.osgi.framework.storage", directory.getAbsolutePath()), moduleConnector);
        this.equinox.init();
        this.systemContext = this.equinox.getBundleContext();
    }

    public Bundle install(File item) throws BundleException, IOException {
        TestModule module = OSGiResolver.getModule(item);
        if (module != null && !module.getName().equals("org.eclipse.osgi") && this.installedIds.add(module.getId())) {
            String path = module.getLocation().getAbsolutePath();
            this.moduleMap.put(path, module);
            return this.systemContext.installBundle(path);
        }
        return null;
    }

    public Map<Bundle, String> resolve() {
        HashMap<Bundle, String> resultMap = new HashMap<Bundle, String>();
        Bundle[] bundles = this.systemContext.getBundles();
        ModuleContainer container = ((Module)this.systemContext.getBundle().adapt(Module.class)).getContainer();
        List<Module> list = Arrays.stream(bundles).filter(b -> b != this.systemContext.getBundle()).map(b -> (Module)b.adapt(Module.class)).filter(Objects::nonNull).toList();
        ResolutionReport report = container.resolve(list, false);
        Map entries = report.getEntries();
        for (Map.Entry module : entries.entrySet()) {
            String message;
            BundleReference reference;
            Bundle bundle;
            Resource key = (Resource)module.getKey();
            if (!(key instanceof BundleReference) || (bundle = (reference = (BundleReference)key).getBundle()).getState() != 2 || (message = report.getResolutionReportMessage(key)) == null || message.isBlank()) continue;
            resultMap.put(bundle, message);
        }
        return resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TestModule getModule(File file) throws IOException {
        Manifest manifest;
        if (file.isFile()) {
            if (file.length() == 0L) {
                return null;
            }
            try (JarFile jarFile = new JarFile(file);){
                manifest = jarFile.getManifest();
            }
        }
        if (!file.isDirectory()) throw new IOException("not a file or directory");
        File manifestFile = new File(file, "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile()) return null;
        try (FileInputStream stream = new FileInputStream(manifestFile);){
            manifest = new Manifest(stream);
        }
        Attributes attributes = manifest.getMainAttributes();
        String value = attributes.getValue("Bundle-SymbolicName");
        if (value == null) return null;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = entry.getKey().toString();
            if ("Bundle-Activator".equalsIgnoreCase(key) || "Require-Capability".equalsIgnoreCase(key) || "Eclipse-PlatformFilter".equalsIgnoreCase(key) || "Service-Component".equalsIgnoreCase(key)) continue;
            headers.put(key, entry.getValue().toString());
        }
        return new TestModule(attributes.getValue("Bundle-SymbolicName").split(";")[0], Version.parseVersion((String)attributes.getValue("Bundle-Version")), headers, file);
    }
}

