/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.reverseresolve;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactDescriptor;

public interface ArtifactCoordinateResolver {
    public Optional<Dependency> resolve(Dependency var1, MavenProject var2, MavenSession var3);

    public static Optional<Path> getPath(Dependency dep) {
        if (dep instanceof ArtifactDescriptor) {
            ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)dep;
            File location = artifactDescriptor.getLocation(true);
            if (location != null && location.exists()) {
                return Optional.of(location.toPath().toAbsolutePath());
            }
        } else {
            String systemPath = dep.getSystemPath();
            if (systemPath != null) {
                try {
                    Path path = Path.of(systemPath, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        return Optional.of(path.toAbsolutePath());
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }
}

