/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.AbstractScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.packaging.LicenseFeatureHelper;

@Deprecated(forRemoval=true)
@Mojo(name="feature-source", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SourceFeatureMojo
extends AbstractMojo {
    static final String GOAL = "feature-source";
    private static final Object LOCK = new Object();
    public static final String FEATURE_TEMPLATE_DIR = "sourceTemplateFeature";
    public static final String SOURCES_FEATURE_CLASSIFIER = "sources-feature";
    private static final String FEATURE_PROPERTIES = "feature.properties";
    private static final String GEN_DIR = "sources-feature";
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="WARN")
    private MissingSourcesAction missingSourcesAction = MissingSourcesAction.WARN;
    @Parameter(defaultValue="true")
    private boolean includeBinaryFeature;
    @Parameter(defaultValue=" Developer Resources")
    private String labelSuffix;
    @Parameter
    private String brandingPlugin;
    @Parameter(defaultValue="true")
    private boolean reuseBrandingPlugin;
    @Parameter
    private PlexusConfiguration excludes;
    @Parameter
    private PlexusConfiguration plugins;
    @Parameter(defaultValue="true")
    protected boolean useDefaultExcludes;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    private final Set<String> excludedPlugins = new HashSet<String>();
    private final Set<String> excludedFeatures = new HashSet<String>();
    private final Set<PluginRef> extraPlugins = new HashSet<PluginRef>();
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component
    private BuildPropertiesParser buildPropertiesParser;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private LicenseFeatureHelper licenseFeatureHelper;
    @Component
    P2ResolverFactory factory;
    @Component
    private Logger logger;
    @Component
    private TychoProjectManager projectManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"eclipse-feature".equals(this.project.getPackaging()) || this.skip) {
            return;
        }
        this.getLog().warn((CharSequence)"The tycho-source-plugin:feature-source is deprecated and will be removed in the next major release of Tycho!");
        this.getLog().warn((CharSequence)"For more details visit: https://github.com/eclipse-tycho/tycho/blob/tycho-5.0.x/REMOVAL.MD");
        Object object = LOCK;
        synchronized (object) {
            try {
                Properties sourceFeatureTemplateProps = this.readSourceTemplateFeatureProperties();
                Properties mergedSourceFeatureProps = this.mergeFeatureProperties(sourceFeatureTemplateProps);
                File sourceFeatureXml = this.generateSourceFeatureXml(mergedSourceFeatureProps, sourceFeatureTemplateProps);
                ReproducibleUtils.storeProperties((Properties)mergedSourceFeatureProps, (Path)this.getMergedSourceFeaturePropertiesFile().toPath());
                MavenArchiver archiver = new MavenArchiver();
                archiver.setArchiver(this.jarArchiver);
                archiver.configureReproducibleBuild(this.outputTimestamp);
                File outputJarFile = this.getOutputJarFile();
                archiver.setOutputFile(outputJarFile);
                File template = new File(this.project.getBasedir(), FEATURE_TEMPLATE_DIR);
                if (template.isDirectory()) {
                    DefaultFileSet templateFileSet = new DefaultFileSet();
                    templateFileSet.setDirectory(template);
                    templateFileSet.setExcludes(new String[]{"feature.xml", FEATURE_PROPERTIES});
                    archiver.getArchiver().addFileSet((FileSet)templateFileSet);
                }
                BuildProperties buildProperties = this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)this.project));
                archiver.getArchiver().addFileSet(this.getManuallyIncludedFiles(this.project.getBasedir(), buildProperties));
                archiver.getArchiver().addFile(sourceFeatureXml, "feature.xml");
                archiver.getArchiver().addFile(this.getMergedSourceFeaturePropertiesFile(), FEATURE_PROPERTIES);
                File licenseFeature = this.licenseFeatureHelper.getLicenseFeature(Feature.read((File)new File(this.project.getBasedir(), "feature.xml")), this.project);
                if (licenseFeature != null) {
                    archiver.getArchiver().addArchivedFileSet(this.licenseFeatureHelper.getLicenseFeatureFileSet(licenseFeature));
                }
                archiver.createArchive(this.session, this.project, this.archive);
                this.projectHelper.attachArtifact(this.project, outputJarFile, "sources-feature");
                if (!this.isP2GenerationEnabled()) {
                    this.logger.warn("org.eclipse.tycho:tycho-p2-plugin seems not to be enabled but will be required if the generated source-feature is used in an update-site or another feature. You can add the following snippet to your pom: \n            <plugin>\n                <groupId>org.eclipse.tycho</groupId>\n                <artifactId>tycho-p2-plugin</artifactId>\n                <executions>\n                    <execution>\n                        <id>attach-p2-metadata</id>\n                        <phase>package</phase>\n                        <goals>\n                            <goal>p2-metadata</goal>\n                        </goals>\n                    </execution>\n                </executions>\n            </plugin>\n");
                }
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not package source feature jar", e);
            }
        }
    }

    protected boolean isP2GenerationEnabled() {
        Plugin plugin = this.project.getPlugin("org.eclipse.tycho:tycho-p2-plugin");
        return plugin != null && plugin.getExecutions().stream().anyMatch(e -> e.getGoals().contains("p2-metadata"));
    }

    static File getSourcesFeatureOutputDir(MavenProject project) {
        File dir = new File(project.getBuild().getDirectory(), "sources-feature");
        dir.mkdirs();
        new File(dir, "p2.inf").delete();
        return dir;
    }

    private Properties mergeFeatureProperties(Properties sourceFeatureTemplateProps) throws IOException {
        Properties generatedOriginalFeatureProps = SourceFeatureMojo.readPropertiesIfExists(new File(this.project.getBuild().getDirectory(), FEATURE_PROPERTIES));
        Properties mergedProperties = new Properties();
        mergedProperties.putAll((Map<?, ?>)generatedOriginalFeatureProps);
        mergedProperties.putAll((Map<?, ?>)sourceFeatureTemplateProps);
        return mergedProperties;
    }

    private Properties readSourceTemplateFeatureProperties() throws IOException {
        return SourceFeatureMojo.readPropertiesIfExists(new File(this.project.getBasedir(), "sourceTemplateFeature/feature.properties"));
    }

    private File generateSourceFeatureXml(Properties mergedSourceFeatureProps, Properties sourceTemplateProps) throws IOException, MojoExecutionException {
        File sourceFeatureXml = new File(SourceFeatureMojo.getSourcesFeatureOutputDir(this.project), "feature.xml");
        Feature feature = Feature.read((File)new File(this.project.getBuild().getDirectory(), "feature.xml"));
        Feature sourceFeature = this.createSourceFeatureSkeleton(feature, mergedSourceFeatureProps, sourceTemplateProps);
        this.fillReferences(sourceFeature, feature, (TargetPlatform)this.projectManager.getTargetPlatform(this.project).orElseThrow(() -> new MojoExecutionException("Tycho build extension not configured for " + String.valueOf(this.project))));
        Feature.write((Feature)sourceFeature, (File)sourceFeatureXml, (String)"  ");
        return sourceFeatureXml;
    }

    private File getMergedSourceFeaturePropertiesFile() {
        return new File(SourceFeatureMojo.getSourcesFeatureOutputDir(this.project), FEATURE_PROPERTIES);
    }

    private static Properties readPropertiesIfExists(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        if (propertiesFile.isFile()) {
            try (FileInputStream propertiesStream = new FileInputStream(propertiesFile);){
                properties.load(propertiesStream);
            }
        }
        return properties;
    }

    Feature createSourceFeatureSkeleton(Feature feature, Properties mergedFeatureProperties, Properties sourceTemplateProperties) throws IOException, MojoExecutionException {
        Document document = new Document();
        document.setEncoding("UTF-8");
        document.setRootNode(new Element("feature"));
        Feature sourceFeature = new Feature(document);
        sourceFeature.setId(feature.getId() + ".source");
        sourceFeature.setVersion(feature.getVersion());
        if (this.reuseBrandingPlugin && this.brandingPlugin == null) {
            if (feature.getBrandingPluginId() != null) {
                sourceFeature.setBrandingPluginId(feature.getBrandingPluginId());
            }
        } else if (this.brandingPlugin != null) {
            sourceFeature.setBrandingPluginId(this.brandingPlugin);
        }
        if (feature.getLabel() != null) {
            String originalLabel = feature.getLabel();
            if (originalLabel.startsWith("%")) {
                sourceFeature.setLabel(SourceFeatureMojo.validateValue(originalLabel, mergedFeatureProperties));
                String labelKey = originalLabel.substring(1);
                if (sourceTemplateProperties.getProperty(labelKey) == null) {
                    mergedFeatureProperties.setProperty(labelKey, mergedFeatureProperties.getProperty(labelKey) + this.labelSuffix);
                }
            } else {
                sourceFeature.setLabel(originalLabel + this.labelSuffix);
            }
        }
        if (feature.getProvider() != null) {
            sourceFeature.setProvider(SourceFeatureMojo.validateValue(feature.getProvider(), mergedFeatureProperties));
        }
        if (feature.getDescription() != null) {
            sourceFeature.setDescription(SourceFeatureMojo.validateValue(feature.getDescription(), mergedFeatureProperties));
        }
        if (feature.getDescriptionURL() != null) {
            sourceFeature.setDescriptionURL(SourceFeatureMojo.validateValue(feature.getDescriptionURL(), mergedFeatureProperties));
        }
        if (feature.getCopyright() != null) {
            sourceFeature.setCopyright(SourceFeatureMojo.validateValue(feature.getCopyright(), mergedFeatureProperties));
        }
        if (feature.getCopyrightURL() != null) {
            sourceFeature.setCopyrightURL(SourceFeatureMojo.validateValue(feature.getCopyrightURL(), mergedFeatureProperties));
        }
        if (feature.getLicense() != null) {
            sourceFeature.setLicense(SourceFeatureMojo.validateValue(feature.getLicense(), mergedFeatureProperties));
        }
        if (feature.getLicenseURL() != null) {
            sourceFeature.setLicenseURL(SourceFeatureMojo.validateValue(feature.getLicenseURL(), mergedFeatureProperties));
        }
        if (this.includeBinaryFeature) {
            FeatureRef binaryRef = new FeatureRef(new Element("includes"));
            binaryRef.setId(feature.getId());
            binaryRef.setVersion(feature.getVersion());
            if (feature.getOS() != null) {
                binaryRef.setOS(feature.getOS());
            }
            if (feature.getWS() != null) {
                binaryRef.setWS(feature.getWS());
            }
            if (feature.getArch() != null) {
                binaryRef.setArch(feature.getArch());
            }
            sourceFeature.addFeatureRef(binaryRef);
        }
        return sourceFeature;
    }

    private static String validateValue(String fieldValue, Properties sourceFeatureProperties) throws MojoExecutionException {
        String key;
        if (fieldValue.startsWith("%") && !sourceFeatureProperties.containsKey(key = fieldValue.substring(1))) {
            throw new MojoExecutionException("Source feature depends on 'sourceTemplateFeature/feature.properties', entry '" + key + "'. However, this key could not be found");
        }
        return fieldValue;
    }

    private void fillReferences(Feature sourceFeature, Feature feature, TargetPlatform targetPlatform) throws MojoExecutionException {
        P2ResolutionResult result;
        P2Resolver p2 = this.factory.createResolver(Collections.singletonList(TargetEnvironment.getRunningEnvironment()));
        ArrayList<PluginRef> missingSourcePlugins = new ArrayList<PluginRef>();
        ArrayList<FeatureRef> missingSourceFeatures = new ArrayList<FeatureRef>();
        ArrayList<PluginRef> missingExtraPlugins = new ArrayList<PluginRef>();
        for (FeatureRef featureRef : feature.getIncludedFeatures()) {
            if (this.excludedFeatures.contains(featureRef.getId())) continue;
            String sourceId = featureRef.getId() + ".source";
            P2ResolutionResult result2 = p2.resolveInstallableUnit(targetPlatform, sourceId + ".feature.jar", this.toStrictVersionRange(featureRef.getVersion()));
            if (result2.getArtifacts().size() == 1) {
                P2ResolutionResult.Entry entry = (P2ResolutionResult.Entry)result2.getArtifacts().iterator().next();
                FeatureRef sourceRef = new FeatureRef(new Element("includes"));
                sourceRef.setId(sourceId);
                sourceRef.setVersion(entry.getVersion());
                sourceFeature.addFeatureRef(sourceRef);
                continue;
            }
            missingSourceFeatures.add(featureRef);
        }
        for (PluginRef pluginRef : feature.getPlugins()) {
            if (this.excludedPlugins.contains(pluginRef.getId())) continue;
            result = p2.resolveInstallableUnit(targetPlatform, pluginRef.getId() + ".source", this.toStrictVersionRange(pluginRef.getVersion()));
            if (result.getArtifacts().size() == 1) {
                this.addPlugin(sourceFeature, result, pluginRef);
                continue;
            }
            missingSourcePlugins.add(pluginRef);
        }
        for (PluginRef pluginRef : this.extraPlugins) {
            result = p2.resolveInstallableUnit(targetPlatform, pluginRef.getId(), pluginRef.getVersion());
            if (result.getArtifacts().size() == 1) {
                this.addPlugin(sourceFeature, result, pluginRef);
                continue;
            }
            missingExtraPlugins.add(pluginRef);
        }
        if (!(missingSourceFeatures.isEmpty() && missingSourcePlugins.isEmpty() && missingExtraPlugins.isEmpty())) {
            if (this.missingSourcesAction == MissingSourcesAction.FAIL) {
                StringBuilder sb = new StringBuilder();
                sb.append("Could not generate source feature for project " + this.project.toString()).append("\n");
                if (!missingSourcePlugins.isEmpty()) {
                    sb.append("    Missing sources for plugins " + ((Object)missingSourcePlugins).toString()).append("\n");
                }
                if (!missingSourceFeatures.isEmpty()) {
                    sb.append("    Missing sources for features " + ((Object)missingSourceFeatures).toString()).append("\n");
                }
                if (!missingExtraPlugins.isEmpty()) {
                    sb.append("    Missing extra plugins " + ((Object)missingExtraPlugins).toString()).append("\n");
                }
                throw new MojoExecutionException(sb.toString());
            }
            this.reportMissing("The following referenced plugins have missing sources", missingSourcePlugins);
            this.reportMissing("The following referenced features have missing sources", missingSourceFeatures);
            this.reportMissing("The following referenced extra plugins have missing sources", missingExtraPlugins);
        }
    }

    private void reportMissing(String msg, List<?> missing) {
        if (missing.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(msg);
        for (Object m : missing) {
            sb.append("\r\n\t");
            sb.append(m);
        }
        sb.append("\r\n");
        this.logger.warn(sb.toString());
    }

    protected String toStrictVersionRange(String version) {
        return "[" + version + "," + version + "]";
    }

    protected void addPlugin(Feature sourceFeature, P2ResolutionResult result, PluginRef pluginRef) {
        P2ResolutionResult.Entry sourceBundle = (P2ResolutionResult.Entry)result.getArtifacts().iterator().next();
        PluginRef sourceRef = new PluginRef("plugin");
        sourceRef.setId(sourceBundle.getId());
        sourceRef.setVersion(sourceBundle.getVersion());
        if (pluginRef.getOs() != null) {
            sourceRef.setOs(pluginRef.getOs());
        }
        if (pluginRef.getWs() != null) {
            sourceRef.setWs(pluginRef.getWs());
        }
        if (pluginRef.getArch() != null) {
            sourceRef.setArch(pluginRef.getArch());
        }
        sourceFeature.addPlugin(sourceRef);
    }

    protected File getOutputJarFile() {
        String filename = this.finalName + "-sources-feature.jar";
        return new File(this.project.getBuild().getDirectory(), filename);
    }

    public void setExcludes(PlexusConfiguration excludes) {
        String id;
        for (PlexusConfiguration plugin : excludes.getChildren("plugin")) {
            id = this.getAttribute(plugin, "id");
            if (id == null) continue;
            this.excludedPlugins.add(id);
        }
        for (PlexusConfiguration plugin : excludes.getChildren("feature")) {
            id = this.getAttribute(plugin, "id");
            if (id == null) continue;
            this.excludedFeatures.add(id);
        }
    }

    public void setPlugins(PlexusConfiguration bundles) {
        for (PlexusConfiguration plugin : bundles.getChildren("plugin")) {
            String id = this.getAttribute(plugin, "id");
            if (id == null) continue;
            String version = this.getAttribute(plugin, "version");
            if (version == null) {
                version = "0.0.0";
            }
            PluginRef ref = new PluginRef("plugin");
            ref.setId(id);
            ref.setVersion(version);
            this.extraPlugins.add(ref);
        }
    }

    private String getAttribute(PlexusConfiguration dom, String attrName) {
        String attr = dom.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).isEmpty()) {
            return null;
        }
        return attr;
    }

    private FileSet getManuallyIncludedFiles(File basedir, BuildProperties buildProperties) {
        ArrayList<String> srcExcludes = new ArrayList<String>(buildProperties.getSourceExcludes());
        srcExcludes.add("feature.xml");
        srcExcludes.add(FEATURE_PROPERTIES);
        return this.getFileSet(basedir, buildProperties.getSourceIncludes(), srcExcludes);
    }

    protected FileSet getFileSet(File basedir, List<String> includes, List<String> excludes) {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(basedir);
        if (includes.isEmpty()) {
            fileSet.setIncludes(new String[]{""});
        } else {
            fileSet.setIncludes(includes.toArray(new String[includes.size()]));
        }
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>();
        if (excludes != null) {
            allExcludes.addAll(excludes);
        }
        if (this.useDefaultExcludes) {
            allExcludes.addAll(Arrays.asList(AbstractScanner.DEFAULTEXCLUDES));
            allExcludes.add("**/.gitignore");
            allExcludes.add("**/.gitattributes");
        }
        fileSet.setExcludes(allExcludes.toArray(new String[allExcludes.size()]));
        return fileSet;
    }

    static boolean isEnabledForProject(MavenProject project) {
        if (!"eclipse-feature".equals(project.getPackaging())) {
            return false;
        }
        Plugin plugin = project.getPlugin("org.eclipse.tycho:tycho-source-plugin");
        if (plugin != null) {
            Xpp3Dom dom;
            Xpp3Dom child;
            PluginExecution execution = plugin.getExecutions().stream().filter(e -> e.getGoals().contains(GOAL)).findFirst().orElse(null);
            if (execution == null) {
                return false;
            }
            Object configuration = execution.getConfiguration();
            if (configuration instanceof Xpp3Dom && (child = (dom = (Xpp3Dom)configuration).getChild("skip")) != null && Boolean.valueOf(child.getValue()).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public static enum MissingSourcesAction {
        FAIL,
        WARN;

    }
}

