/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.helper.ProjectHelper;

@Component(role=PluginRealmHelper.class)
public class PluginRealmHelper {
    @Requirement
    private Logger logger;
    @Requirement
    private MavenPluginManager pluginManager;
    @Requirement
    private BuildPluginManager buildPluginManager;
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private ProjectHelper projectHelper;

    public <T> void visitPluginExtensions(MavenProject project, MavenSession mavenSession, Class<T> type, Consumer<? super T> consumer) throws PluginVersionResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, PluginResolutionException, PluginManagerException {
        HashSet visited = new HashSet();
        this.execute(project, mavenSession, () -> {
            try {
                this.plexus.lookupList(type).stream().filter(x -> visited.add(x.getClass().getName())).forEach(consumer);
            }
            catch (ComponentLookupException e) {
                this.logger.debug("Cannot lookup any item of type: " + type);
            }
        }, PluginRealmHelper::isTychoEmbedderPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenProject project, MavenSession mavenSession, Runnable runnable, PluginFilter filter) throws PluginVersionResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, PluginResolutionException, PluginManagerException {
        if (mavenSession.getLocalRepository() == null) {
            return;
        }
        MavenSession executeSession = mavenSession.clone();
        executeSession.setCurrentProject(project);
        this.lifecyclePluginResolver.resolveMissingPluginVersions(project, executeSession);
        List<Plugin> plugins = this.projectHelper.getPlugins(project, executeSession);
        for (Plugin plugin : plugins) {
            ClassRealm pluginRealm;
            PluginDescriptor pluginDescriptor;
            if (plugin.isExtensions()) continue;
            try {
                pluginDescriptor = this.mavenPluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), executeSession.getRepositorySession());
            }
            catch (PluginResolutionException e) {
                this.logger.debug("PluginResolutionException while looking for components from " + plugin, (Throwable)e);
                continue;
            }
            if (pluginDescriptor == null || filter != null && !filter.accept(pluginDescriptor) || (pluginRealm = this.buildPluginManager.getPluginRealm(executeSession, pluginDescriptor)) == null) continue;
            ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
                runnable.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(origTCCL);
            }
        }
    }

    private static boolean isTychoEmbedderPlugin(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getArtifactMap().containsKey("org.eclipse.tycho:tycho-spi")) {
            return true;
        }
        for (ComponentDependency dependency : pluginDescriptor.getDependencies()) {
            if (!"org.eclipse.tycho".equals(dependency.getGroupId()) || !"tycho-spi".equals(dependency.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public static interface PluginFilter {
        public boolean accept(PluginDescriptor var1);
    }
}

