/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public interface RepositoryGenerator {
    public File createRepository(List<MavenProject> var1, RepositoryConfiguration var2) throws IOException, MojoExecutionException, MojoFailureException;

    default public boolean isInteresting(MavenProject mavenProject) {
        String packaging = mavenProject.getPackaging();
        return "jar".equalsIgnoreCase(packaging) || "bundle".equalsIgnoreCase(packaging) || "eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging);
    }

    public static interface RepositoryConfiguration {
        public File getDestination();

        public RepositoryLayout getLayout();

        public String getRepositoryName();

        public PlexusConfiguration getConfiguration();

        public Log getLog();
    }

    public static enum RepositoryLayout {
        maven,
        local;

    }
}

