/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.util.DefaultScanResult;
import org.apache.maven.surefire.api.util.ScanResult;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.OSGiJavaToolchain;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;

public abstract class AbstractTestMojo
extends AbstractMojo {
    protected static final String IMPORT_REQUIRED_PACKAGES = "*";
    protected static final String IMPORT_PACKAGES_OPTIONAL = "*;resolution:=optional";
    @Parameter(defaultValue="${project.build.directory}/work")
    protected File work;
    @Parameter(property="tycho.surefire.deleteWorkDir")
    private boolean deleteWorkDirAfterTest;
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter
    protected List<String> includes;
    @Parameter
    protected List<String> excludes;
    @Parameter(property="test")
    protected String test;
    @Parameter(property="skipTests")
    protected Boolean skipTests;
    @Parameter(property="failIfNoTests", defaultValue="true")
    protected boolean failIfNoTests;
    @Parameter(property="testClass")
    private String testClass;
    @Parameter(defaultValue="SYSTEM")
    private ToolchainProvider.JDKUsage useJDK;
    @Parameter(property="maven.test.skip")
    protected Boolean skip;
    @Parameter(property="tycho.printBundles", defaultValue="false")
    protected boolean printBundles;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected TychoProjectManager projectManager;
    @Component
    protected ToolchainProvider toolchainProvider;
    @Component
    protected BuildPropertiesParser buildPropertiesParser;
    @Component(role=TychoProject.class, hint="eclipse-plugin")
    protected OsgiBundleProject osgiBundle;
    @Parameter(property="plugin.artifacts")
    protected List<Artifact> pluginArtifacts;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isCompatiblePackagingType(this.project.getPackaging())) {
            this.getLog().debug((CharSequence)("Execution was skipped because of incompatible packaging type: " + this.project.getPackaging()));
            return;
        }
        if (this.shouldSkip()) {
            this.getLog().info((CharSequence)"Skipping tests");
            return;
        }
        ScanResult result = this.scanForTests();
        if (result.size() == 0) {
            this.handleNoTestsFound();
            return;
        }
        try {
            this.runTests(result);
        }
        finally {
            if (this.deleteWorkDirAfterTest) {
                FileUtils.deleteQuietly((File)this.work);
            }
        }
    }

    protected ScanResult scanForTests() {
        List<String> excludeList;
        List<Object> includeList;
        List<String> defaultIncludes = this.getDefaultInclude();
        List<String> defaultExcludes = this.getDefaultExclude();
        if (this.test != null) {
            Object test = this.test;
            test = ((String)(test = ((String)test).replace('.', '/'))).endsWith(".class") ? test : (String)test + ".class";
            test = ((String)test).startsWith("**/") ? test : "**/" + (String)test;
            includeList = Collections.singletonList(test);
        } else if (this.testClass != null) {
            includeList = Collections.singletonList(this.testClass.replace('.', '/') + ".class");
        } else if (this.includes != null) {
            includeList = this.includes;
            includeList.removeAll(Collections.singleton(null));
        } else {
            includeList = defaultIncludes;
        }
        if (this.excludes != null) {
            excludeList = this.excludes;
            excludeList.removeAll(Collections.singleton(null));
        } else {
            excludeList = defaultExcludes;
        }
        TestListResolver resolver = new TestListResolver(includeList, excludeList);
        DirectoryScanner scanner = new DirectoryScanner(this.getTestClassesDirectory(), resolver);
        DefaultScanResult scanResult = scanner.scan();
        List classes = scanResult.getClasses();
        for (String clazz : classes) {
            this.getLog().debug((CharSequence)("Class " + clazz + " matches the current filter"));
        }
        if (classes.isEmpty()) {
            this.getLog().debug((CharSequence)("Nothing matches pattern " + String.valueOf(includeList) + ", excluding " + String.valueOf(excludeList) + " in " + String.valueOf(this.getTestClassesDirectory())));
        }
        return scanResult;
    }

    protected List<String> getDefaultExclude() {
        return Arrays.asList("**/*$*");
    }

    protected List<String> getDefaultInclude() {
        return List.of("**/Test*.class", "**/*Test.class", "**/*Tests.class", "**/*TestCase.class");
    }

    protected abstract void runTests(ScanResult var1) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isCompatiblePackagingType(String var1);

    protected boolean shouldSkip() {
        if (this.skip != null && this.skipTests != null && !this.skip.equals(this.skipTests)) {
            this.getLog().warn((CharSequence)"Both parameters 'skipTests' and 'maven.test.skip' are set. 'skipTests' has a higher priority");
        }
        if (this.skipTests != null) {
            return this.skipTests;
        }
        if (this.skip != null) {
            return this.skip;
        }
        return false;
    }

    protected ReactorProject getReactorProject() {
        return DefaultReactorProject.adapt((MavenProject)this.project);
    }

    protected Optional<ResolvedArtifactKey> createTestPluginJar(ReactorProject reactorProject, String packageImport, ScanResult scanResult) throws Exception {
        ResolvedArtifactKey result;
        UUID uuid = UUID.randomUUID();
        String artifactBaseName = FilenameUtils.getBaseName((String)reactorProject.getArtifact().getName());
        String testJarName = artifactBaseName + "-test-" + String.valueOf(uuid) + ".jar";
        File fragmentFile = new File(this.project.getBuild().getDirectory(), testJarName);
        if (fragmentFile.exists() && !fragmentFile.delete()) {
            throw new IllegalStateException("Could not delete the existing fragment file " + String.valueOf(fragmentFile));
        }
        File outDir = new File(this.project.getBuild().getTestOutputDirectory());
        if (!outDir.isDirectory()) {
            return Optional.empty();
        }
        try (Jar mainArtifact = new Jar(reactorProject.getArtifact());
             Jar jar = new Jar(reactorProject.getName() + " test classes", outDir, null);
             Analyzer analyzer = new Analyzer(jar);){
            Collection additionalBundles;
            if (jar.getResources().isEmpty()) {
                Optional<ResolvedArtifactKey> optional = Optional.empty();
                return optional;
            }
            Manifest bundleManifest = mainArtifact.getManifest();
            String hostVersion = bundleManifest.getMainAttributes().getValue("Bundle-Version");
            String fragmentHost = this.getFragmentHost(bundleManifest, hostVersion);
            String bundleName = "Test fragment for %s:%s:%s".formatted(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
            analyzer.setProperty("Bundle-Version", hostVersion);
            String fragmentId = this.project.getGroupId() + "-" + this.project.getArtifactId() + "-" + String.valueOf(uuid);
            analyzer.setProperty("Bundle-SymbolicName", fragmentId);
            analyzer.setProperty("Fragment-Host", fragmentHost);
            analyzer.setProperty("Bundle-Name", bundleName);
            analyzer.setProperty("Import-Package", packageImport);
            if (scanResult != null) {
                String collect = IntStream.range(0, scanResult.size()).mapToObj(arg_0 -> ((ScanResult)scanResult).getClassName(arg_0)).collect(Collectors.joining(","));
                if (!collect.isEmpty()) {
                    analyzer.setProperty("Test-Cases", collect);
                }
            }
            if (!(additionalBundles = this.buildPropertiesParser.parse(reactorProject).getAdditionalBundles()).isEmpty()) {
                String stringValue = additionalBundles.stream().map(b -> b + ";resolution:=optional").collect(Collectors.joining(","));
                analyzer.setProperty("Require-Bundle", stringValue);
            }
            List testClasspath = this.osgiBundle.getTestClasspath(reactorProject);
            for (ClasspathEntry classpathEntry : testClasspath) {
                for (File location : classpathEntry.getLocations()) {
                    analyzer.addClasspath(location);
                }
            }
            analyzer.addClasspath(mainArtifact);
            Manifest manifest = analyzer.calcManifest();
            if (this.printBundles) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                manifest.write(out);
                System.out.println("---------- Test Bundle Fragment Manifest ---------");
                System.out.println(new String(out.toByteArray()));
                System.out.println("--------------------------------------------------");
            }
            jar.setManifest(manifest);
            jar.write(fragmentFile);
            result = ResolvedArtifactKey.of((String)"eclipse-plugin", (String)fragmentId, (String)hostVersion, (File)fragmentFile);
        }
        return Optional.of(result);
    }

    private String getFragmentHost(Manifest manifest, String hostVersion) {
        Attributes attributes = manifest.getMainAttributes();
        String host = attributes.getValue("Fragment-Host");
        if (host != null) {
            return host;
        }
        String value = attributes.getValue("Bundle-SymbolicName");
        int separatorIndex = value.indexOf(59);
        String hostSymbolicName = separatorIndex > -1 ? value.substring(0, separatorIndex) : value;
        return "%s;%s=\"%s\"".formatted(hostSymbolicName, "bundle-version", hostVersion);
    }

    protected List<TargetEnvironment> getTestTargetEnvironments() {
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(this.project);
        List targetEnvironments = configuration.getEnvironments();
        TargetEnvironment runningEnvironment = TargetEnvironment.getRunningEnvironment();
        for (TargetEnvironment targetEnvironment : targetEnvironments) {
            if (!targetEnvironment.equals((Object)runningEnvironment)) continue;
            this.getLog().debug((CharSequence)("Using matching target environment " + String.valueOf(targetEnvironment.toFilterProperties()) + " to resolve test artifacts"));
            return List.of(targetEnvironment);
        }
        this.getLog().warn((CharSequence)("Your build environment " + String.valueOf(runningEnvironment.toFilterProperties()) + " does not match any of the configured target environments " + String.valueOf(targetEnvironments) + ". Test execution might be inconsistent"));
        return targetEnvironments;
    }

    protected Optional<OSGiJavaToolchain> getToolchain() throws MojoExecutionException {
        String profileName = this.getTestProfileName();
        Optional toolchain = this.toolchainProvider.getToolchain(this.useJDK, profileName);
        if (this.useJDK == ToolchainProvider.JDKUsage.BREE && toolchain.isEmpty()) {
            throw new MojoExecutionException("useJDK = BREE configured, but no toolchain of type 'jdk' with id '" + profileName + "' found. See https://maven.apache.org/guides/mini/guide-using-toolchains.html");
        }
        return toolchain;
    }

    protected String getTestProfileName() {
        return this.projectManager.getExecutionEnvironmentConfiguration(this.project).getProfileName();
    }

    protected String getJavaExecutable() throws MojoExecutionException {
        return this.getToolchain().map(tc -> {
            this.getLog().debug((CharSequence)("Toolchain in tycho-surefire-plugin: " + String.valueOf(tc)));
            return tc.findTool("java");
        }).orElse("java");
    }

    protected void handleNoTestsFound() throws MojoFailureException {
        String message = "No tests found";
        if (this.failIfNoTests) {
            throw new MojoFailureException(message);
        }
        this.getLog().warn((CharSequence)message);
    }

    protected static IRequirement createBundleRequirement(String id) {
        return MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true);
    }

    protected abstract File getReportsDirectory();

    protected abstract File getTestClassesDirectory();
}

