/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.surefire.AbstractEclipseTestMojo;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class TestPluginMojo
extends AbstractEclipseTestMojo {
    @Parameter(property="project.build.outputDirectory")
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter
    private boolean quiet;
    @Parameter(property="tycho.test.packaging", defaultValue="eclipse-test-plugin")
    private String packaging = "eclipse-test-plugin";

    @Override
    protected boolean isCompatiblePackagingType(String projectPackaging) {
        return this.packaging.equals(projectPackaging);
    }

    @Override
    protected File getReportsDirectory() {
        return this.reportsDirectory;
    }

    @Override
    protected void handleSuccess() {
        if (!this.quiet) {
            this.getLog().info((CharSequence)"All tests passed");
        }
    }

    @Override
    protected void handleTestFailures() throws MojoFailureException {
        String errorMessage = "There are test failures.\n\nPlease refer to " + String.valueOf(this.reportsDirectory) + " for the individual test results.\n\n";
        if (this.testFailureIgnore) {
            if (!this.quiet) {
                this.getLog().error((CharSequence)errorMessage);
            }
        } else {
            throw new MojoFailureException(errorMessage);
        }
    }

    @Override
    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }
}

