/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.targetplatform;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetResolveException;

public interface TargetPlatformArtifactResolver {
    public static final String TARGET_TYPE = "target";

    public File resolveTargetFile(String var1, String var2, String var3, String var4, MavenSession var5, List<ArtifactRepository> var6) throws TargetResolveException;

    public Optional<File> getReactorTargetFile(String var1, String var2, String var3, String var4, MavenSession var5) throws TargetResolveException;

    public static File getMainTargetFile(MavenProject project) throws TargetResolveException {
        File[] targetFiles = TargetDefinitionFile.listTargetFiles(project.getBasedir());
        if (targetFiles == null || targetFiles.length == 0) {
            throw new TargetResolveException("No target definition file(s) found in project '" + project.getName() + "'.");
        }
        if (targetFiles.length == 1) {
            return targetFiles[0];
        }
        for (File targetFile : targetFiles) {
            String baseName = FilenameUtils.getBaseName((String)targetFile.getName());
            if (!baseName.equalsIgnoreCase(project.getArtifactId())) continue;
            return targetFile;
        }
        throw new TargetResolveException("One target file must be named  '" + project.getArtifactId() + ".target' when multiple targets are present");
    }
}

