/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.util.Base64;
import javax.json.bind.JsonbException;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;

public class ByteArrayBase64Serializer
extends AbstractValueTypeSerializer<byte[]> {
    public ByteArrayBase64Serializer(Class<byte[]> clazz, JsonBindingModel model) {
        super(model);
    }

    @Override
    protected void serialize(byte[] obj, JsonGenerator generator, String key, Marshaller marshaller) {
        generator.write(key, this.getEncoder(marshaller.getJsonbContext().getConfigProperties().getBinaryDataStrategy()).encodeToString(obj));
    }

    @Override
    protected void serialize(byte[] obj, JsonGenerator generator, Marshaller marshaller) {
        generator.write(this.getEncoder(marshaller.getJsonbContext().getConfigProperties().getBinaryDataStrategy()).encodeToString(obj));
    }

    private Base64.Encoder getEncoder(String strategy) {
        switch (strategy) {
            case "BASE_64": {
                return Base64.getEncoder();
            }
            case "BASE_64_URL": {
                return Base64.getUrlEncoder();
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Invalid strategy: " + strategy));
    }
}

