/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.elasticsearch.xcontent.DelegatingXContentParser;
import org.elasticsearch.xcontent.FilterXContentParser;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;

public class DotExpandingXContentParser
extends FilterXContentParser {
    final String[] subPaths;
    final XContentParser subparser;
    private XContentLocation currentLocation;
    private int expandedTokens = 0;
    private int innerLevel = -1;
    private State state = State.EXPANDING_START_OBJECT;

    private static String[] splitAndValidatePath(String fullFieldPath) {
        if (fullFieldPath.isEmpty()) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        if (!fullFieldPath.contains(".")) {
            return new String[]{fullFieldPath};
        }
        String[] parts = fullFieldPath.split("\\.");
        if (parts.length == 0) {
            throw new IllegalArgumentException("field name cannot contain only dots");
        }
        for (String part : parts) {
            if (part.isEmpty()) {
                throw new IllegalArgumentException("field name cannot contain only whitespace: ['" + fullFieldPath + "']");
            }
            if (!part.isBlank()) continue;
            throw new IllegalArgumentException("field name starting or ending with a [.] makes object resolution ambiguous: [" + fullFieldPath + "]");
        }
        return parts;
    }

    public static XContentParser expandDots(XContentParser in) throws IOException {
        return new WrappingParser(in);
    }

    private DotExpandingXContentParser(XContentParser subparser, XContentParser root, String[] subPaths, XContentLocation startLocation) {
        super(root);
        this.subPaths = subPaths;
        this.subparser = subparser;
        this.currentLocation = startLocation;
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            ++this.expandedTokens;
            assert (this.expandedTokens < this.subPaths.length * 2);
            if (this.expandedTokens == this.subPaths.length * 2 - 1) {
                this.state = State.PARSING_ORIGINAL_CONTENT;
                XContentParser.Token token = this.in.currentToken();
                if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                    ++this.innerLevel;
                }
                return token;
            }
            if (this.expandedTokens % 2 == 0) {
                return XContentParser.Token.FIELD_NAME;
            }
            return XContentParser.Token.START_OBJECT;
        }
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            XContentParser.Token token = this.subparser.nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                ++this.innerLevel;
            }
            if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                --this.innerLevel;
            }
            if (token != null) {
                return token;
            }
            this.currentLocation = this.getTokenLocation();
            this.state = State.ENDING_EXPANDED_OBJECT;
        }
        assert (this.expandedTokens % 2 == 1);
        this.expandedTokens -= 2;
        return this.expandedTokens < 0 ? null : XContentParser.Token.END_OBJECT;
    }

    @Override
    public XContentLocation getTokenLocation() {
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            return super.getTokenLocation();
        }
        return this.currentLocation;
    }

    @Override
    public XContentParser.Token currentToken() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.EXPANDING_START_OBJECT -> {
                if (this.expandedTokens % 2 == 1) {
                    yield XContentParser.Token.START_OBJECT;
                }
                yield XContentParser.Token.FIELD_NAME;
            }
            case State.ENDING_EXPANDED_OBJECT -> XContentParser.Token.END_OBJECT;
            case State.PARSING_ORIGINAL_CONTENT -> this.in.currentToken();
        };
    }

    @Override
    public String currentName() throws IOException {
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            assert (this.expandedTokens == this.subPaths.length * 2 - 1);
            if (this.innerLevel > 0) {
                return this.in.currentName();
            }
            XContentParser.Token token = this.currentToken();
            if (this.innerLevel == 0 && token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
                return this.in.currentName();
            }
        }
        return this.subPaths[this.expandedTokens / 2];
    }

    @Override
    public void skipChildren() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            this.in.skipChildren();
            this.state = State.ENDING_EXPANDED_OBJECT;
        }
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            this.subparser.skipChildren();
        }
    }

    @Override
    public String textOrNull() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get text on a " + this.currentToken() + " at " + this.getTokenLocation());
        }
        return super.textOrNull();
    }

    @Override
    public Number numberValue() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get numeric value on a " + this.currentToken() + " at " + this.getTokenLocation());
        }
        return super.numberValue();
    }

    @Override
    public boolean booleanValue() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get boolean value on a " + this.currentToken() + " at " + this.getTokenLocation());
        }
        return super.booleanValue();
    }

    private static class WrappingParser
    extends DelegatingXContentParser {
        final Deque<XContentParser> parsers = new ArrayDeque<XContentParser>();

        WrappingParser(XContentParser in) throws IOException {
            this.parsers.push(in);
            if (in.currentToken() == XContentParser.Token.FIELD_NAME) {
                this.expandDots();
            }
        }

        @Override
        public XContentParser.Token nextToken() throws IOException {
            XContentParser.Token token;
            while ((token = this.delegate().nextToken()) == null) {
                this.parsers.pop();
                if (!this.parsers.isEmpty()) continue;
                return null;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                return token;
            }
            this.expandDots();
            return XContentParser.Token.FIELD_NAME;
        }

        private void expandDots() throws IOException {
            String field = this.delegate().currentName();
            String[] subpaths = DotExpandingXContentParser.splitAndValidatePath(field);
            if (subpaths.length == 0) {
                throw new IllegalArgumentException("field name cannot contain only dots: [" + field + "]");
            }
            if (subpaths.length == 1 && !field.endsWith(".")) {
                return;
            }
            XContentLocation location = this.delegate().getTokenLocation();
            XContentParser.Token token = this.delegate().nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                this.parsers.push(new DotExpandingXContentParser(new XContentSubParser(this.delegate()), this.delegate(), subpaths, location));
            } else {
                if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                    throw new IllegalStateException("Expecting START_OBJECT or START_ARRAY or VALUE but got [" + token + "]");
                }
                this.parsers.push(new DotExpandingXContentParser(new SingletonValueXContentParser(this.delegate()), this.delegate(), subpaths, location));
            }
        }

        @Override
        protected XContentParser delegate() {
            return this.parsers.peek();
        }
    }

    private static enum State {
        EXPANDING_START_OBJECT,
        PARSING_ORIGINAL_CONTENT,
        ENDING_EXPANDED_OBJECT;

    }

    private static class SingletonValueXContentParser
    extends FilterXContentParser {
        protected SingletonValueXContentParser(XContentParser in) {
            super(in);
        }

        @Override
        public XContentParser.Token nextToken() throws IOException {
            return null;
        }
    }
}

