/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.TokenFilter;
import java.util.Set;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.support.filtering.FilterPath;
import org.elasticsearch.xcontent.support.filtering.FilterPathBasedFilter;

public class XContentParserConfiguration {
    public static final XContentParserConfiguration EMPTY = new XContentParserConfiguration(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, RestApiVersion.current(), null, null, false);
    final NamedXContentRegistry registry;
    final DeprecationHandler deprecationHandler;
    final RestApiVersion restApiVersion;
    final FilterPath[] includes;
    final FilterPath[] excludes;
    final boolean filtersMatchFieldNamesWithDots;

    private XContentParserConfiguration(NamedXContentRegistry registry, DeprecationHandler deprecationHandler, RestApiVersion restApiVersion, FilterPath[] includes, FilterPath[] excludes, boolean filtersMatchFieldNamesWithDots) {
        this.registry = registry;
        this.deprecationHandler = deprecationHandler;
        this.restApiVersion = restApiVersion;
        this.includes = includes;
        this.excludes = excludes;
        this.filtersMatchFieldNamesWithDots = filtersMatchFieldNamesWithDots;
    }

    public XContentParserConfiguration withRegistry(NamedXContentRegistry registry) {
        return new XContentParserConfiguration(registry, this.deprecationHandler, this.restApiVersion, this.includes, this.excludes, this.filtersMatchFieldNamesWithDots);
    }

    public NamedXContentRegistry registry() {
        return this.registry;
    }

    public XContentParserConfiguration withDeprecationHandler(DeprecationHandler deprecationHandler) {
        return new XContentParserConfiguration(this.registry, deprecationHandler, this.restApiVersion, this.includes, this.excludes, this.filtersMatchFieldNamesWithDots);
    }

    public DeprecationHandler deprecationHandler() {
        return this.deprecationHandler;
    }

    public XContentParserConfiguration withRestApiVersion(RestApiVersion restApiVersion) {
        return new XContentParserConfiguration(this.registry, this.deprecationHandler, restApiVersion, this.includes, this.excludes, this.filtersMatchFieldNamesWithDots);
    }

    public RestApiVersion restApiVersion() {
        return this.restApiVersion;
    }

    public XContentParserConfiguration withFiltering(Set<String> includeStrings, Set<String> excludeStrings, boolean filtersMatchFieldNamesWithDots) {
        return new XContentParserConfiguration(this.registry, this.deprecationHandler, this.restApiVersion, FilterPath.compile(includeStrings), FilterPath.compile(excludeStrings), filtersMatchFieldNamesWithDots);
    }

    public JsonParser filter(JsonParser parser) {
        JsonParser filtered = parser;
        if (this.excludes != null) {
            for (FilterPath e : this.excludes) {
                if (!e.hasDoubleWildcard()) continue;
                throw new UnsupportedOperationException("double wildcards are not supported in filtered excludes");
            }
            filtered = new FilteringParserDelegate(filtered, (TokenFilter)new FilterPathBasedFilter(this.excludes, false, this.filtersMatchFieldNamesWithDots), true, true);
        }
        if (this.includes != null) {
            filtered = new FilteringParserDelegate(filtered, (TokenFilter)new FilterPathBasedFilter(this.includes, true, this.filtersMatchFieldNamesWithDots), true, true);
        }
        return filtered;
    }
}

