/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductObject;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsTableUsage;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public class TableUsage
extends TypePart {
    public static final String MSGCODE_REQUIRED_TABLE_IS_NOT_SET = "REQUIRED_TABLE_IS_NOT_SET";
    public static final String MSGKEY_REQUIRED_TABLE_IS_NOT_SET = "TableUsage.RequiredTableIsNotSet";
    public static final String PROPERTY_REQUIRED_TABLE = "requiredTable";
    private final Method getter;

    public TableUsage(Type parent, Method getter) {
        super(getter.getAnnotation(IpsTableUsage.class).name(), parent, getter.getAnnotation(IpsExtensionProperties.class), Deprecation.of(getter));
        this.getter = getter;
    }

    public ITable<?> getTable(IProductComponent productComponent, Calendar effectiveDate) {
        try {
            return (ITable)this.getter.invoke((Object)TableUsage.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime()), new Object[0]);
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            throw this.getterError(productComponent, e);
        }
    }

    public String getTableName(IProductComponent productComponent, Calendar effectiveDate) {
        String tableName = null;
        try {
            Method getterForName = this.getter.getDeclaringClass().getDeclaredMethod(this.getter.getName() + "Name", new Class[0]);
            tableName = (String)getterForName.invoke((Object)TableUsage.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime()), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Could not get table name for table usage %s on product component %s.", this.getName(), productComponent), e);
        }
        return tableName;
    }

    public void setTableName(String tableName, IProductComponent productComponent, Calendar effectiveDate) {
        this.setTableName(tableName, TableUsage.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime()));
    }

    public void setTableName(String tableName, IProductComponentGeneration generation) {
        this.setTableName(tableName, TableUsage.getRelevantProductObject(generation, this.isChangingOverTime()));
    }

    private void setTableName(String tableName, IProductObject productObject) {
        try {
            String setterNameForTableName = "set" + this.getter.getName().substring(3) + "Name";
            Method setterForName = this.getter.getDeclaringClass().getDeclaredMethod(setterNameForTableName, String.class);
            setterForName.invoke((Object)productObject, tableName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            IProductObject iProductObject;
            Object[] objectArray = new Object[2];
            objectArray[0] = this.getName();
            if (productObject instanceof IProductComponentGeneration) {
                IProductComponentGeneration gen = (IProductComponentGeneration)productObject;
                iProductObject = gen.getProductComponent();
            } else {
                iProductObject = productObject;
            }
            objectArray[1] = iProductObject;
            throw new IllegalArgumentException(String.format("Could not set table name for table usage %s on product component %s.", objectArray), e);
        }
    }

    public boolean isRequired() {
        return this.getter.getAnnotation(IpsTableUsage.class).required();
    }

    @Override
    public void validate(MessageList list, IValidationContext context, IProductComponent productComponent, Calendar effectiveDate) {
        ResourceBundle messages = ResourceBundle.getBundle(TableUsage.class.getName(), context.getLocale());
        String formatString = String.format(messages.getString(MSGKEY_REQUIRED_TABLE_IS_NOT_SET), this.getLabel(context.getLocale()), productComponent.getId());
        if (this.isRequired() && IpsStringUtils.isEmpty(this.getTableName(productComponent, effectiveDate))) {
            list.newError(MSGCODE_REQUIRED_TABLE_IS_NOT_SET, formatString, new ObjectProperty(this, PROPERTY_REQUIRED_TABLE), new ObjectProperty(productComponent, this.getName()));
        }
    }

    @Override
    public boolean isChangingOverTime() {
        return IProductComponentGeneration.class.isAssignableFrom(this.getter.getDeclaringClass());
    }

    @Deprecated(forRemoval=true)
    public TableStructure getTableStructure() {
        Class<ITable> tableClass = this.getter.getReturnType().asSubclass(ITable.class);
        if (tableClass.equals(ITable.class)) {
            throw new UnsupportedOperationException("Cannot create new TableStructure as the table usage " + this.getName() + " uses multiple table structures.");
        }
        return IpsModel.getTableStructure(tableClass);
    }

    public List<TableStructure> getTableStructures() {
        Class<? extends ITable<?>>[] tableClasses = this.getter.getAnnotation(IpsTableUsage.class).tableClasses();
        return Arrays.stream(tableClasses).map(IpsModel::getTableStructure).toList();
    }

    private IllegalArgumentException getterError(IProductComponent source, Exception e) {
        return new IllegalArgumentException(String.format("Could not get table %s on product component %s.", this.getName(), source), e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.getter.getReturnType());
        return sb.toString();
    }
}

