/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.faktorips.runtime.DefaultCacheFactory;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IRuntimeRepositoryLookup;
import org.faktorips.runtime.internal.AbstractClassLoadingRuntimeRepository;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ClassloaderRuntimeRepository
extends AbstractClassLoadingRuntimeRepository {
    public static final String REPOSITORY_XML_ELEMENT = "ProductComponentRegistry";
    public static final String TABLE_OF_CONTENTS_FILE = "faktorips-repository-toc.xml";
    private static final InputStream EMPTY_INPUT_STREAM = new EmptyInputStream();
    private final String tocResourcePath;

    public ClassloaderRuntimeRepository(ClassLoader cl, String basePackage) {
        this(cl, basePackage, TABLE_OF_CONTENTS_FILE, new DefaultCacheFactory(cl));
    }

    public ClassloaderRuntimeRepository(ClassLoader cl, String basePackage, String pathToToc) {
        this(cl, basePackage, pathToToc, new DefaultCacheFactory(cl));
    }

    public ClassloaderRuntimeRepository(ClassLoader cl, String basePackage, String pathToToc, ICacheFactory cacheFactory) {
        super(Objects.requireNonNull(basePackage), cacheFactory, Objects.requireNonNull(cl));
        Objects.requireNonNull(pathToToc);
        this.tocResourcePath = "".equals(basePackage) ? pathToToc : basePackage.replace('.', '/') + "/" + pathToToc;
        this.initialize();
    }

    private ClassloaderRuntimeRepository(String tocResource, ClassLoader cl, ICacheFactory cacheFactory) {
        super(Objects.requireNonNull(tocResource), cacheFactory, Objects.requireNonNull(cl));
        this.tocResourcePath = tocResource;
        this.initialize();
    }

    public static final ClassloaderRuntimeRepository create(String tocResource) {
        return ClassloaderRuntimeRepository.create(tocResource, ClassloaderRuntimeRepository.class.getClassLoader(), new DefaultCacheFactory(ClassloaderRuntimeRepository.class.getClassLoader()));
    }

    public static final ClassloaderRuntimeRepository create(String tocResource, ICacheFactory cacheFactory) {
        return ClassloaderRuntimeRepository.create(tocResource, ClassloaderRuntimeRepository.class.getClassLoader(), cacheFactory);
    }

    public static final ClassloaderRuntimeRepository create(String tocResource, ClassLoader cl) {
        return ClassloaderRuntimeRepository.create(tocResource, cl, new DefaultCacheFactory(cl));
    }

    public static final ClassloaderRuntimeRepository create(String tocResource, ClassLoader cl, ICacheFactory cacheFactory) {
        return new ClassloaderRuntimeRepository(tocResource, cl, cacheFactory);
    }

    @Override
    protected ReadonlyTableOfContents loadTableOfContents() {
        Document doc;
        try (InputStream is = this.getClassLoader().getResourceAsStream(this.tocResourcePath);){
            if (is == null) {
                throw new IllegalArgumentException("Can't find table of contents file " + this.tocResourcePath);
            }
            doc = XmlUtil.getDocumentBuilder().parse(new InputSource(new InputStreamReader(is, StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading table of contents from " + this.tocResourcePath, e);
        }
        try {
            Element tocElement = doc.getDocumentElement();
            ReadonlyTableOfContents toc = new ReadonlyTableOfContents(this.getClassLoader());
            toc.initFromXml(tocElement);
            return toc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating ToC from XML.", e);
        }
    }

    @Override
    protected String getProductComponentGenerationImplClass(GenerationTocEntry tocEntry) {
        return tocEntry.getImplementationClassName();
    }

    @Override
    protected InputStream getXmlAsStream(TableContentTocEntry tocEntry) {
        InputStream is = this.getClassLoader().getResourceAsStream(tocEntry.getXmlResourceName());
        if (is == null) {
            throw new RuntimeException("Can't find resource " + tocEntry.getXmlResourceName() + " for ToC entry " + String.valueOf(tocEntry));
        }
        return is;
    }

    @Override
    protected InputStream getXmlAsStream(EnumContentTocEntry tocEntry) {
        String xmlResourceName = tocEntry.getXmlResourceName();
        if (IpsStringUtils.isBlank(xmlResourceName)) {
            return EMPTY_INPUT_STREAM;
        }
        InputStream is = this.getClassLoader().getResourceAsStream(xmlResourceName);
        if (is == null) {
            throw new RuntimeException("Cant't load the input stream for the enumeration content resource " + xmlResourceName);
        }
        return is;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    public void withLookup() {
        this.setRuntimeRepositoryLookup(new IRuntimeRepositoryLookup.RuntimeRepositoryLookupByToC(this.tocResourcePath, this));
    }

    private static final class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

