/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.lang.reflect.Method;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IUnresolvedReference;

public class DefaultUnresolvedReference
implements IUnresolvedReference {
    private Object sourceObj;
    private Object sourceObjId;
    private Method establishMethod;
    private Object targetId;
    private Class<?> targetClass;

    public DefaultUnresolvedReference(Object sourceObj, Object sourceObjId, Method establishMethod, Class<?> targetClass, Object targetId) {
        this.sourceObj = sourceObj;
        this.sourceObjId = sourceObjId;
        this.establishMethod = establishMethod;
        this.targetClass = targetClass;
        this.targetId = targetId;
    }

    public DefaultUnresolvedReference(Object sourceObj, Object sourceObjId, String establishMethodName, Class<?> targetClass, Object targetId) {
        this.sourceObj = sourceObj;
        this.sourceObjId = sourceObjId;
        this.targetClass = targetClass;
        this.targetId = targetId;
        try {
            this.establishMethod = sourceObj.getClass().getMethod(establishMethodName, targetClass);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.throwNewRuntimeException(sourceObj, establishMethodName, targetClass);
        }
    }

    private void throwNewRuntimeException(Object sourceObj, String establishMethodName, Class<?> targetClass) {
        throw new RuntimeException("Can't get method to establish association, sourceClass=" + sourceObj.getClass().getName() + "method=" + establishMethodName + ", targetClass=" + targetClass.getName());
    }

    @Override
    public void resolve(IObjectReferenceStore store) throws Exception {
        Object target = store.getObject(this.targetClass, this.targetId);
        this.establishMethod.invoke(this.sourceObj, target);
    }

    public Method getEstablishMethod() {
        return this.establishMethod;
    }

    public Object getSourceObj() {
        return this.sourceObj;
    }

    public Object getSourceObjId() {
        return this.sourceObjId;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Object getTargetId() {
        return this.targetId;
    }

    public String toString() {
        return "Unresolved reference: From " + String.valueOf(this.sourceObj) + "(" + String.valueOf(this.sourceObjId) + ")To: " + String.valueOf(this.targetClass) + "(" + String.valueOf(this.targetId) + ")Method to estabalish: " + String.valueOf(this.establishMethod);
    }
}

