/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.xml.IIpsXmlAdapter;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;

public class InMemoryRuntimeRepository
extends AbstractRuntimeRepository
implements IModifiableRuntimeRepository {
    private HashMap<String, IProductComponent> productCmpts = new HashMap();
    private HashMap<String, SortedSet<IProductComponentGeneration>> productCmptGenLists = new HashMap();
    private List<ITable<?>> singleContentTables = new ArrayList();
    private Map<String, ITable<?>> multipleContentTables = new HashMap();
    private HashMap<String, IpsTestCaseBase> testCasesByQName = new HashMap();
    private Map<Class<?>, List<?>> enumValuesMap = new HashMap();
    private Map<Class<?>, InternationalString> enumDescriptionMap = new HashMap();
    private List<IIpsXmlAdapter<?, ?>> enumXmlAdapters = new LinkedList();
    private Map<Class<?>, Map<String, IRuntimeObject>> customRuntimeObjectsByType = new HashMap();

    public InMemoryRuntimeRepository() {
        super("InMemoryRuntimeRepository");
    }

    public InMemoryRuntimeRepository(String name) {
        super(name);
    }

    @Override
    protected IProductComponent getProductComponentInternal(String id) {
        return this.productCmpts.get(id);
    }

    @Override
    protected IProductComponent getProductComponentInternal(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("Not implemented yet.");
        }
        for (IProductComponent cmpt : this.productCmpts.values()) {
            if (!kindId.equals(cmpt.getKindId()) || !versionId.equals(cmpt.getVersionId())) continue;
            return cmpt;
        }
        return null;
    }

    @Override
    public void getAllProductComponents(String kindId, List<IProductComponent> result) {
        for (IProductComponent cmpt : this.productCmpts.values()) {
            if (!kindId.equals(cmpt.getKindId())) continue;
            result.add(cmpt);
        }
    }

    private SortedSet<IProductComponentGeneration> getLoadedProductCmptGenerations(String productCmptId) {
        return this.productCmptGenLists.computeIfAbsent(productCmptId, $ -> new TreeSet<IProductComponentGeneration>(new ProductCmptGenerationComparator(TimeZone.getDefault())));
    }

    @Override
    public void getProductComponentGenerations(IProductComponent productCmpt, List<IProductComponentGeneration> result) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        if (genSet != null) {
            result.addAll(genSet);
        }
    }

    public void initialize() {
    }

    @Override
    protected void getAllTables(List<ITable<?>> result) {
        Stream.concat(this.singleContentTables.stream(), this.multipleContentTables.values().stream()).sorted(Comparator.comparing(ITable::getName, String.CASE_INSENSITIVE_ORDER)).forEach(result::add);
    }

    @Override
    public void getAllTableIds(List<String> result) {
        Stream.concat(this.singleContentTables.stream().map(ITable::getName), this.multipleContentTables.keySet().stream()).distinct().sorted(String.CASE_INSENSITIVE_ORDER).forEach(result::add);
    }

    @Override
    protected <T extends ITable<?>> T getTableInternal(Class<T> tableClass) {
        for (ITable<?> table : this.singleContentTables) {
            if (!tableClass.isAssignableFrom(table.getClass())) continue;
            return (T)((ITable)tableClass.cast(table));
        }
        return null;
    }

    @Override
    public Optional<ITable<?>> putTable(ITable<?> table) {
        if (IpsStringUtils.isNotBlank(table.getName()) && this.isMultiContent(table.getClass())) {
            return this.putMultipleContentTable(table);
        }
        return this.putSingleContentTable(table);
    }

    private Optional<ITable<?>> putMultipleContentTable(ITable<?> table) {
        this.multipleContentTables.put(table.getName(), table);
        return Optional.empty();
    }

    private Optional<ITable<?>> putSingleContentTable(ITable<?> table) {
        Class<?> tableClass = table.getClass();
        Optional<ITable<?>> oldTable = Optional.empty();
        Iterator<ITable<?>> it = this.singleContentTables.iterator();
        while (it.hasNext()) {
            ITable<?> each = it.next();
            if (!each.getClass().isAssignableFrom(tableClass) && !tableClass.isAssignableFrom(each.getClass())) continue;
            it.remove();
            oldTable = Optional.of(each);
        }
        this.singleContentTables.add(table);
        return oldTable;
    }

    @Deprecated(since="24.7", forRemoval=true)
    public void putTable(ITable<?> table, String qName) {
        if (this.isMultiContent(table.getClass())) {
            this.multipleContentTables.put(qName, table);
        } else {
            this.putSingleContentTable(table);
        }
    }

    @Override
    public <T> void putEnumValues(Class<T> enumTypeClass, List<T> enumValues, InternationalString description) {
        this.enumValuesMap.put(enumTypeClass, new ArrayList<T>(enumValues));
        this.enumDescriptionMap.put(enumTypeClass, description);
    }

    @Override
    public <T> boolean removeEnumValues(Class<T> enumTypeClass) {
        return this.enumValuesMap.remove(enumTypeClass) != null | this.enumDescriptionMap.remove(enumTypeClass) != null;
    }

    @Override
    public <T> InternationalString getEnumDescription(Class<T> enumClazz) {
        return this.enumDescriptionMap.getOrDefault(enumClazz, (InternationalString)DefaultInternationalString.EMPTY);
    }

    @Override
    protected ITable<?> getTableInternal(String qualifiedTableName) {
        for (ITable<?> table : this.singleContentTables) {
            if (!qualifiedTableName.equals(table.getName())) continue;
            return table;
        }
        return this.multipleContentTables.get(qualifiedTableName);
    }

    @Override
    public void getAllProductComponents(List<IProductComponent> result) {
        result.addAll(this.productCmpts.values());
    }

    @Override
    public void getAllProductComponentIds(List<String> result) {
        result.addAll(this.productCmpts.keySet());
    }

    @Override
    protected void getAllEnumClasses(LinkedHashSet<Class<?>> result) {
        result.addAll(this.enumValuesMap.keySet());
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public void putProductComponent(IProductComponent productCmpt) {
        Objects.requireNonNull(productCmpt);
        this.productCmpts.put(productCmpt.getId(), productCmpt);
    }

    @Override
    public boolean removeProductComponent(IProductComponent productCmpt) {
        Objects.requireNonNull(productCmpt);
        String id = productCmpt.getId();
        if (IpsStringUtils.isBlank(id)) {
            throw new IllegalArgumentException("Product component has no ID");
        }
        return this.productCmpts.remove(id) != null;
    }

    @Override
    public boolean removeTable(ITable<?> table) {
        Objects.requireNonNull(table);
        String name = table.getName();
        if (this.isMultiContent(table.getClass())) {
            if (IpsStringUtils.isBlank(name)) {
                throw new IllegalArgumentException("Table has no name");
            }
            return this.multipleContentTables.remove(name) != null;
        }
        return this.singleContentTables.remove(table);
    }

    @Override
    public boolean removeProductCmptGeneration(IProductComponentGeneration productCmptGeneration) {
        Objects.requireNonNull(productCmptGeneration);
        IProductComponent productComponent = productCmptGeneration.getProductComponent();
        if (productComponent == null) {
            throw new IllegalArgumentException("Product component generation has no associated product component");
        }
        String id = productComponent.getId();
        if (IpsStringUtils.isBlank(id)) {
            throw new IllegalArgumentException("Product component has no ID");
        }
        if (this.productCmptGenLists.get(id) == null) {
            throw new IllegalArgumentException("No generations found for product component with ID: " + id);
        }
        return this.productCmptGenLists.get(id).remove(productCmptGeneration);
    }

    @Override
    public boolean removeIpsTestCase(IpsTestCaseBase test) {
        Objects.requireNonNull(test);
        String qualifiedName = test.getQualifiedName();
        if (IpsStringUtils.isBlank(qualifiedName)) {
            throw new IllegalArgumentException("The given test case has no qualified name.");
        }
        return this.testCasesByQName.remove(qualifiedName) != null;
    }

    @Override
    protected IProductComponentGeneration getProductComponentGenerationInternal(String productCmptId, Calendar effectiveDate) {
        if (productCmptId == null || effectiveDate == null) {
            return null;
        }
        SortedSet<IProductComponentGeneration> generations = this.getLoadedProductCmptGenerations(productCmptId);
        IProductComponentGeneration foundGen = null;
        long effectiveTime = effectiveDate.getTimeInMillis();
        long foundGenValidFrom = Long.MIN_VALUE;
        for (IProductComponentGeneration gen : generations) {
            long genValidFrom = gen.getValidFrom(effectiveDate.getTimeZone()).getTime();
            if (effectiveTime < genValidFrom || genValidFrom <= foundGenValidFrom) continue;
            foundGen = gen;
            foundGenValidFrom = genValidFrom;
        }
        return foundGen;
    }

    @Override
    public void putProductCmptGeneration(IProductComponentGeneration generation) {
        Objects.requireNonNull(generation);
        this.getLoadedProductCmptGenerations(generation.getProductComponent().getId()).add(generation);
        this.putProductComponent(generation.getProductComponent());
    }

    @Override
    protected void getAllIpsTestCases(List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        result.addAll(this.testCasesByQName.values());
    }

    @Override
    protected void getIpsTestCasesStartingWith(String qNamePrefix, List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        for (String qName : this.testCasesByQName.keySet()) {
            if (!qName.startsWith(qNamePrefix)) continue;
            result.add(this.testCasesByQName.get(qName));
        }
    }

    @Override
    protected IpsTestCaseBase getIpsTestCaseInternal(String qName, IRuntimeRepository runtimeRepository) {
        return this.testCasesByQName.get(qName);
    }

    @Override
    public void putIpsTestCase(IpsTestCaseBase test) {
        this.testCasesByQName.put(test.getQualifiedName(), test);
    }

    @Override
    protected void getAllModelTypeImplementationClasses(Set<String> result) {
        this.streamAllModelTypes().map(Class::getName).distinct().forEach(result::add);
    }

    private Stream<? extends Class<?>> streamAllModelTypes() {
        return Stream.of(this.includingSuperTypes(this.getAllPolicyCmptTypes()).map(Type::getJavaClass), this.includingSuperTypes(this.getAllProductCmptTypes()).map(Type::getJavaClass), this.getAllEnumClasses().stream(), this.getAllTables().stream().map((Function<ITable, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/faktorips/runtime/ITable;)Ljava/lang/Class;)())).flatMap(s -> s);
    }

    private Stream<? extends Type> includingSuperTypes(Stream<? extends Type> streamOfTypes) {
        return streamOfTypes.flatMap(type -> type.isSuperTypePresent() ? Stream.concat(Stream.of(type), this.includingSuperTypes(Stream.of(type.getSuperType()))) : Stream.of(type));
    }

    private Stream<PolicyCmptType> getAllPolicyCmptTypes() {
        return this.getAllProductCmptTypes().filter(ProductCmptType::isConfigurationForPolicyCmptType).map(ProductCmptType::getPolicyCmptType);
    }

    private Stream<ProductCmptType> getAllProductCmptTypes() {
        return this.getAllProductComponents().stream().map(IpsModel::getProductCmptType);
    }

    @Override
    protected IProductComponentGeneration getNextProductComponentGenerationInternal(IProductComponentGeneration generation) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(generation.getProductComponent().getId());
        SortedSet<IProductComponentGeneration> successor = genSet.tailSet(generation);
        if (successor == null) {
            return null;
        }
        for (IProductComponentGeneration next : successor) {
            if (next.equals(generation)) continue;
            return next;
        }
        return null;
    }

    @Override
    protected int getNumberOfProductComponentGenerationsInternal(IProductComponent productCmpt) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        return genSet.size();
    }

    @Override
    protected IProductComponentGeneration getPreviousProductComponentGenerationInternal(IProductComponentGeneration generation) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(generation.getProductComponent().getId());
        SortedSet<IProductComponentGeneration> predecessors = genSet.headSet(generation);
        if (predecessors.isEmpty()) {
            return null;
        }
        return predecessors.last();
    }

    @Override
    protected IProductComponentGeneration getLatestProductComponentGenerationInternal(IProductComponent productCmpt) {
        Objects.requireNonNull(productCmpt);
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        return genSet.last();
    }

    @Override
    protected <T> List<T> getEnumValuesInternal(Class<T> clazz) {
        List<?> values = this.enumValuesMap.get(clazz);
        if (values == null) {
            return null;
        }
        return Collections.unmodifiableList(values);
    }

    public void addEnumXmlAdapter(IIpsXmlAdapter<?, ?> enumXmlAdapter) {
        this.enumXmlAdapters.add(enumXmlAdapter);
    }

    @Override
    protected List<IIpsXmlAdapter<?, ?>> getAllInternalEnumXmlAdapters(IRuntimeRepository repository) {
        return this.enumXmlAdapters;
    }

    @Override
    public <T extends IRuntimeObject> void putCustomRuntimeObject(Class<T> type, String ipsObjectQualifiedName, T runtimeObject) {
        Map customRuntimeObjects = this.customRuntimeObjectsByType.computeIfAbsent(type, $ -> new HashMap());
        customRuntimeObjects.put(ipsObjectQualifiedName, runtimeObject);
    }

    @Override
    protected <T> T getCustomRuntimeObjectInternal(Class<T> type, String ipsObjectQualifiedName) {
        Map<String, IRuntimeObject> otherRuntimeObjects = this.customRuntimeObjectsByType.get(type);
        if (otherRuntimeObjects != null) {
            return InMemoryRuntimeRepository.cast(otherRuntimeObjects.get(ipsObjectQualifiedName));
        }
        return null;
    }

    @Override
    public <T> boolean removeCustomRuntimeObject(Class<T> type, String ipsObjectQualifiedName) {
        Map<String, IRuntimeObject> otherRuntimeObjects = this.customRuntimeObjectsByType.get(type);
        return otherRuntimeObjects != null ? otherRuntimeObjects.remove(ipsObjectQualifiedName) != null : false;
    }

    private static <T> T cast(IRuntimeObject runtimeObject) {
        return (T)runtimeObject;
    }

    private static class ProductCmptGenerationComparator
    implements Comparator<IProductComponentGeneration> {
        private TimeZone timeZone;

        private ProductCmptGenerationComparator(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public int compare(IProductComponentGeneration gen1, IProductComponentGeneration gen2) {
            if (Objects.equals(gen1, gen2)) {
                return 0;
            }
            if (gen1.getValidFrom(this.timeZone).before(gen2.getValidFrom(this.timeZone))) {
                return -1;
            }
            if (gen1.getValidFrom(this.timeZone).after(gen2.getValidFrom(this.timeZone))) {
                return 1;
            }
            return 0;
        }
    }
}

