/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateTime
implements Comparable<DateTime>,
Serializable {
    private static final long serialVersionUID = 908669872768116989L;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int hashCode;

    public DateTime(int year, int month, int day) {
        this(year, month, day, 0, 0, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.hashCode = year + 17 * month + 34 * day + hour + 41 * hour;
    }

    public static final DateTime parseIso(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(s, "-");
            int year = Integer.parseInt(tokenizer.nextToken());
            int month = Integer.parseInt(tokenizer.nextToken());
            int date = Integer.parseInt(tokenizer.nextToken());
            return new DateTime(year, month, date);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't parse " + s + " to a DateTime!");
        }
    }

    public static final DateTime createDateOnly(GregorianCalendar calendar) {
        return Optional.ofNullable(calendar).map(cal -> new DateTime(cal.get(1), cal.get(2) + 1, cal.get(5))).orElse(null);
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public long toTimeInMillisecs(TimeZone zone) {
        return this.toGregorianCalendar(zone).getTimeInMillis();
    }

    public Date toDate(TimeZone zone) {
        return this.toGregorianCalendar(zone).getTime();
    }

    public GregorianCalendar toGregorianCalendar(TimeZone zone) {
        GregorianCalendar cal = new GregorianCalendar(zone);
        cal.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        cal.set(14, 0);
        return cal;
    }

    public String toIsoFormat() {
        return "%04d-%02d-%02d".formatted(this.year, this.month, this.day);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateTime)) {
            return false;
        }
        DateTime other = (DateTime)o;
        return this.year == other.year && this.month == other.month && this.day == other.day && this.hour == other.hour && this.minute == other.minute && this.second == other.second;
    }

    public String toString() {
        return "%s %02d:%02d:%02d".formatted(this.toIsoFormat(), this.hour, this.minute, this.second);
    }

    @Override
    public int compareTo(DateTime other) {
        if (this.year != other.year) {
            return this.year - other.year;
        }
        if (this.month != other.month) {
            return this.month - other.month;
        }
        if (this.day != other.day) {
            return this.day - other.day;
        }
        if (this.hour != other.hour) {
            return this.hour - other.hour;
        }
        if (this.minute != other.minute) {
            return this.minute - other.minute;
        }
        return this.second - other.second;
    }
}

