/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.faktorips.values.ObjectUtil;

public enum RangeType {
    LOWER_BOUND{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> floorEntry = tree.floorEntry(key);
            if (floorEntry == null) {
                return Optional.empty();
            }
            return RangeType.getLowerValueIfNeccessary(tree, key, floorEntry);
        }
    }
    ,
    LOWER_BOUND_EQUAL{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> floorEntry = tree.floorEntry(key);
            return RangeType.getOptionalValue(floorEntry);
        }
    }
    ,
    UPPER_BOUND{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> ceilingEntry = tree.ceilingEntry(key);
            if (ceilingEntry == null) {
                return Optional.empty();
            }
            return RangeType.getHigherValueIfNeccessary(tree, key, ceilingEntry);
        }
    }
    ,
    UPPER_BOUND_EQUAL{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            return this.findValue(tree, key).orElse(null);
        }

        @Override
        public <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> tree, K key) {
            if (ObjectUtil.isNull(key)) {
                return Optional.empty();
            }
            Map.Entry<K, V> ceilingEntry = tree.ceilingEntry(key);
            return RangeType.getOptionalValue(ceilingEntry);
        }
    };


    public abstract <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> var1, K var2);

    public abstract <K extends Comparable<? super K>, V> Optional<V> findValue(TreeMap<K, V> var1, K var2);

    private static <K extends Comparable<? super K>, V> Optional<V> getLowerValueIfNeccessary(TreeMap<K, V> tree, K key, Map.Entry<K, V> floorEntry) {
        return ((Comparable)floorEntry.getKey()).compareTo(key) < 0 ? Optional.ofNullable(floorEntry.getValue()) : RangeType.getOptionalValue(tree.lowerEntry((Comparable)floorEntry.getKey()));
    }

    private static <K extends Comparable<? super K>, V> Optional<V> getHigherValueIfNeccessary(TreeMap<K, V> tree, K key, Map.Entry<K, V> ceilingEntry) {
        return ((Comparable)ceilingEntry.getKey()).compareTo(key) > 0 ? Optional.ofNullable(ceilingEntry.getValue()) : RangeType.getOptionalValue(tree.higherEntry((Comparable)ceilingEntry.getKey()));
    }

    private static <K, V> Optional<V> getOptionalValue(Map.Entry<K, V> entry) {
        return Optional.ofNullable(entry).map(Map.Entry::getValue);
    }
}

