/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Objects;

class TwoColumnRange<K extends Comparable<? super K>>
implements Comparable<TwoColumnRange<K>>,
Serializable {
    private static final long serialVersionUID = 42L;
    private final Bound<K> lowerBound;
    private final Bound<K> upperBound;

    TwoColumnRange(K lowerBound, K upperBound) {
        this(lowerBound, upperBound, true, true);
    }

    TwoColumnRange(K lowerBound, K upperBound, boolean lowerInclusive, boolean upperInclusive) {
        this.lowerBound = lowerBound == null ? Bound.negativeInfinity() : new Bound<K>(lowerBound, IntervalDirection.getLowerBoundDirection(lowerInclusive));
        this.upperBound = upperBound == null ? Bound.positiveInfinity() : new Bound<K>(upperBound, IntervalDirection.getUpperBoundDirection(upperInclusive));
    }

    @Override
    public int compareTo(TwoColumnRange<K> other) {
        return this.lowerBound.compareTo(other.lowerBound);
    }

    public int compareToUpperBound(TwoColumnRange<K> otherKey) {
        return this.upperBound.compareTo(otherKey.upperBound);
    }

    public boolean isOverlapping(TwoColumnRange<K> otherRange) {
        return this.lowerBound.compareTo(otherRange.upperBound) < 0 && this.upperBound.compareTo(otherRange.lowerBound) > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TwoColumnRange other = (TwoColumnRange)obj;
        return this.lowerBound.equals(other.lowerBound);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + this.lowerBound.hashCode();
    }

    public K getLowerBound() {
        return this.lowerBound.boundaryValue;
    }

    public boolean isLowerInclusive() {
        return this.lowerBound.direction.isLowerInclulsive();
    }

    public K getUpperBound() {
        return this.upperBound.boundaryValue;
    }

    public boolean isUpperInclusive() {
        return this.upperBound.direction.isUpperInclulsive();
    }

    public String toString() {
        return "TwoColumnRange " + String.valueOf((Object)this.lowerBound.direction) + String.valueOf(this.lowerBound.boundaryValue) + "," + String.valueOf(this.upperBound.boundaryValue) + String.valueOf((Object)this.upperBound.direction);
    }

    @SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR", "SING_SINGLETON_IMPLEMENTS_SERIALIZABLE"}, justification="SpotBugs wrongly assumes this class is a singleton, but it has two static final instances and is instantiated in generated code.")
    private static final class Bound<K extends Comparable<? super K>>
    implements Comparable<Bound<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Bound<?> NEGATIVE_INFINITY = new Bound<Object>(null, IntervalDirection.LEFT);
        private static final Bound<?> POSITIVE_INFINITY = new Bound<Object>(null, IntervalDirection.RIGHT);
        private final K boundaryValue;
        private final IntervalDirection direction;

        public Bound(K boundaryValue, IntervalDirection direction) {
            this.boundaryValue = boundaryValue;
            this.direction = direction;
        }

        public static <K extends Comparable<? super K>> Bound<K> negativeInfinity() {
            return NEGATIVE_INFINITY;
        }

        public static <K extends Comparable<? super K>> Bound<K> positiveInfinity() {
            return POSITIVE_INFINITY;
        }

        @Override
        public int compareTo(Bound<K> otherBound) {
            if (this.isInfinity() || otherBound.isInfinity()) {
                return this.compareInfinity(otherBound);
            }
            int compareLowerBound = this.boundaryValue.compareTo(otherBound.boundaryValue);
            if (this.direction == otherBound.direction || compareLowerBound != 0) {
                return compareLowerBound;
            }
            return this.direction == IntervalDirection.RIGHT ? -1 : 1;
        }

        private int compareInfinity(Bound<K> otherBound) {
            if (this.isInfinity() && otherBound.isInfinity()) {
                if (this.direction == otherBound.direction) {
                    return 0;
                }
                return this.direction == IntervalDirection.LEFT ? -1 : 1;
            }
            if (this.isInfinity()) {
                return this.direction == IntervalDirection.LEFT ? -1 : 1;
            }
            return otherBound.direction == IntervalDirection.RIGHT ? -1 : 1;
        }

        private boolean isInfinity() {
            return this.boundaryValue == null;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.boundaryValue, this.direction});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bound other = (Bound)obj;
            return Objects.equals(this.boundaryValue, other.boundaryValue) && this.direction == other.direction;
        }
    }

    private static enum IntervalDirection {
        LEFT("]"),
        RIGHT("[");

        private final String toStringRepresentation;

        private IntervalDirection(String toStringRepresentation) {
            this.toStringRepresentation = toStringRepresentation;
        }

        public static IntervalDirection getLowerBoundDirection(boolean inclusive) {
            if (inclusive) {
                return RIGHT;
            }
            return LEFT;
        }

        public static IntervalDirection getUpperBoundDirection(boolean inclusive) {
            if (inclusive) {
                return LEFT;
            }
            return RIGHT;
        }

        public boolean isLowerInclulsive() {
            return this == RIGHT;
        }

        public boolean isUpperInclulsive() {
            return this == LEFT;
        }

        public String toString() {
            return this.toStringRepresentation;
        }
    }
}

