/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.w3c.dom.Element;

public class ProductCmptTocEntry
extends TocEntryObject {
    public static final String PROPERTY_KIND_ID = "kindId";
    public static final String PROPERTY_VERSION_ID = "versionId";
    public static final String PROPERTY_VALID_TO = "validTo";
    public static final String PROPERTY_GENERATION_IMPL_CLASS_NAME = "generationImplClassName";
    public static final String XML_TAG = "ProductComponent";
    private TreeMap<Long, GenerationTocEntry> generationEntries = ProductCmptTocEntry.createNewTreeMap();
    private final String kindId;
    private final String versionId;
    private final DateTime validTo;
    private final String generationImplClassName;

    public ProductCmptTocEntry(String ipsObjectId, String ipsObjectQualifiedName, String kindId, String versionId, String xmlResourceName, String implementationClassName, String generationImplClassName, DateTime validTo) {
        super(ipsObjectId, ipsObjectQualifiedName, xmlResourceName, implementationClassName);
        this.kindId = kindId;
        this.versionId = versionId;
        this.validTo = validTo;
        this.generationImplClassName = generationImplClassName;
    }

    public String getKindId() {
        return this.kindId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public DateTime getValidTo() {
        return this.validTo;
    }

    public List<GenerationTocEntry> getGenerationEntries() {
        return new ArrayList<GenerationTocEntry>(this.generationEntries.values());
    }

    public int getNumberOfGenerationEntries() {
        return this.generationEntries == null ? 0 : this.generationEntries.size();
    }

    public String getGenerationImplClassName() {
        return this.generationImplClassName;
    }

    public void setGenerationEntries(List<GenerationTocEntry> entries) {
        this.generationEntries = ProductCmptTocEntry.createNewTreeMap();
        entries.forEach(entry -> this.generationEntries.put(entry.getValidFromInMillisec(TimeZone.getDefault()), (GenerationTocEntry)entry));
    }

    public GenerationTocEntry getNextGenerationEntry(Calendar validFrom) {
        return this.findNextGenerationEntry(validFrom).orElse(null);
    }

    public Optional<GenerationTocEntry> findNextGenerationEntry(Calendar validFrom) {
        SortedMap<Long, GenerationTocEntry> map = this.generationEntries.headMap(validFrom.getTimeInMillis());
        if (map.isEmpty()) {
            return Optional.empty();
        }
        return map.isEmpty() ? Optional.empty() : Optional.ofNullable(this.generationEntries.get(map.lastKey()));
    }

    public GenerationTocEntry getPreviousGenerationEntry(Calendar validFrom) {
        return this.findPreviousGenerationEntry(validFrom).orElse(null);
    }

    public Optional<GenerationTocEntry> findPreviousGenerationEntry(Calendar validFrom) {
        SortedMap<Long, GenerationTocEntry> map = this.generationEntries.tailMap(validFrom.getTimeInMillis() - 1L);
        if (map.isEmpty()) {
            return Optional.empty();
        }
        Long key = map.firstKey();
        return Optional.ofNullable(this.generationEntries.get(key));
    }

    public GenerationTocEntry getLatestGenerationEntry() {
        return this.findLatestGenerationEntry().orElse(null);
    }

    public Optional<GenerationTocEntry> findLatestGenerationEntry() {
        if (this.generationEntries.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.generationEntries.get(this.generationEntries.firstKey()));
    }

    public GenerationTocEntry getGenerationEntry(Calendar effectiveDate) {
        return this.findGenerationEntry(effectiveDate).orElse(null);
    }

    public Optional<GenerationTocEntry> findGenerationEntry(Calendar effectiveDate) {
        if (effectiveDate == null) {
            return Optional.empty();
        }
        SortedMap<Long, GenerationTocEntry> map = this.generationEntries.tailMap(effectiveDate.getTimeInMillis() + 1L);
        if (map.isEmpty()) {
            return Optional.empty();
        }
        Long key = map.firstKey();
        return Optional.ofNullable(this.generationEntries.get(key));
    }

    public GenerationTocEntry getGenerationEntry(DateTime validAt) {
        return this.findGenerationEntry(validAt).orElse(null);
    }

    public Optional<GenerationTocEntry> findGenerationEntry(DateTime validAt) {
        return Optional.ofNullable(this.generationEntries.get(validAt.toTimeInMillisecs(TimeZone.getDefault())));
    }

    @Override
    protected void addToXml(Element entryElement) {
        super.addToXml(entryElement);
        entryElement.setAttribute(PROPERTY_KIND_ID, this.kindId);
        entryElement.setAttribute(PROPERTY_VERSION_ID, this.versionId);
        Optional.ofNullable(this.validTo).ifPresent(v -> entryElement.setAttribute(PROPERTY_VALID_TO, v.toIsoFormat()));
        if (!this.getGenerationEntries().isEmpty()) {
            entryElement.setAttribute(PROPERTY_GENERATION_IMPL_CLASS_NAME, this.generationImplClassName);
            this.generationEntries.values().forEach(generationEntry -> entryElement.appendChild(generationEntry.toXml(entryElement.getOwnerDocument())));
        }
    }

    @Override
    protected String getXmlElementTag() {
        return XML_TAG;
    }

    private static TreeMap<Long, GenerationTocEntry> createNewTreeMap() {
        return new TreeMap<Long, GenerationTocEntry>(Comparator.reverseOrder());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.generationEntries == null ? 0 : this.generationEntries.size());
        result = 31 * result + (this.generationImplClassName == null ? 0 : this.generationImplClassName.hashCode());
        result = 31 * result + (this.kindId == null ? 0 : this.kindId.hashCode());
        result = 31 * result + (this.validTo == null ? 0 : this.validTo.hashCode());
        return 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        ProductCmptTocEntry other;
        block5: {
            block4: {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof ProductCmptTocEntry)) break block4;
                other = (ProductCmptTocEntry)obj;
                if (super.equals(obj)) break block5;
            }
            return false;
        }
        return Objects.equals(this.generationEntries, other.generationEntries) && Objects.equals(this.generationImplClassName, other.generationImplClassName) && Objects.equals(this.kindId, other.kindId) && Objects.equals(this.validTo, other.validTo) && Objects.equals(this.versionId, other.versionId);
    }
}

