/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.xml;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.xml.IIpsXmlAdapter;

public interface IIpsLocalDateTimeAdapter
extends IIpsXmlAdapter<String, LocalDateTime> {
    @Override
    default public LocalDateTime unmarshal(String v) {
        if (IpsStringUtils.isBlank(v)) {
            return null;
        }
        try {
            return LocalDateTime.parse(v);
        }
        catch (DateTimeParseException e) {
            LocalDateTime localDateTimeWithMilliseconds = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss:SSS").parse((CharSequence)v, LocalDateTime::from);
            return localDateTimeWithMilliseconds.withNano(0);
        }
    }

    @Override
    default public String marshal(LocalDateTime v) {
        return v == null ? null : v.toString();
    }
}

