/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.Store2CachePollingScheduler;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.Property;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.utils.Util;

public class FF4jCacheProxy
implements FeatureStore,
PropertyStore {
    private FeatureStore targetFeatureStore;
    private PropertyStore targetPropertyStore;
    private FF4JCacheManager cacheManager;
    private Store2CachePollingScheduler store2CachePoller = null;

    public FF4jCacheProxy() {
    }

    public FF4jCacheProxy(FeatureStore fStore, PropertyStore pStore, FF4JCacheManager cache) {
        this.cacheManager = cache;
        this.targetFeatureStore = fStore;
        this.targetPropertyStore = pStore;
        this.store2CachePoller = new Store2CachePollingScheduler(fStore, pStore, cache);
    }

    public void startPolling(long delay) {
        if (this.store2CachePoller == null) {
            throw new IllegalStateException("The poller has not been initialize, please check");
        }
        this.getStore2CachePoller().start(delay);
    }

    public void stopPolling() {
        if (this.store2CachePoller == null) {
            throw new IllegalStateException("The poller has not been initialize, please check");
        }
        this.getStore2CachePoller().stop();
    }

    @Override
    public void enable(String featureId) {
        this.getTargetFeatureStore().enable(featureId);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void disable(String featureId) {
        this.getTargetFeatureStore().disable(featureId);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public boolean exist(String featureId) {
        Util.assertHasLength(featureId);
        try {
            if (this.getCacheManager().getFeature(featureId) == null) {
                return this.getTargetFeatureStore().exist(featureId);
            }
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
        return true;
    }

    @Override
    public void createSchema() {
        this.getTargetFeatureStore().createSchema();
        this.getTargetPropertyStore().createSchema();
    }

    @Override
    public void create(Feature fp) {
        this.getTargetFeatureStore().create(fp);
        try {
            this.getCacheManager().putFeature(fp);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public Feature read(String featureUid) {
        Feature fp = this.getCacheManager().getFeature(featureUid);
        if (null == fp) {
            fp = this.getTargetFeatureStore().read(featureUid);
            try {
                this.getCacheManager().putFeature(fp);
            }
            catch (RuntimeException re) {
                this.getCacheManager().onException(re);
            }
        }
        return fp;
    }

    @Override
    public Map<String, Feature> readAll() {
        return this.getTargetFeatureStore().readAll();
    }

    @Override
    public Set<String> readAllGroups() {
        return this.getTargetFeatureStore().readAllGroups();
    }

    @Override
    public void delete(String featureId) {
        this.getTargetFeatureStore().delete(featureId);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void update(Feature fp) {
        this.getTargetFeatureStore().update(fp);
        try {
            this.getCacheManager().evictFeature(fp.getUid());
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void grantRoleOnFeature(String featureId, String roleName) {
        this.getTargetFeatureStore().grantRoleOnFeature(featureId, roleName);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void removeRoleFromFeature(String featureId, String roleName) {
        this.getTargetFeatureStore().removeRoleFromFeature(featureId, roleName);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void enableGroup(String groupName) {
        this.getTargetFeatureStore().enableGroup(groupName);
        try {
            this.getCacheManager().clearFeatures();
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void disableGroup(String groupName) {
        this.getTargetFeatureStore().disableGroup(groupName);
        try {
            this.getCacheManager().clearFeatures();
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public boolean existGroup(String groupName) {
        return this.getTargetFeatureStore().existGroup(groupName);
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        return this.getTargetFeatureStore().readGroup(groupName);
    }

    @Override
    public void addToGroup(String featureId, String groupName) {
        this.getTargetFeatureStore().addToGroup(featureId, groupName);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void removeFromGroup(String featureId, String groupName) {
        this.getTargetFeatureStore().removeFromGroup(featureId, groupName);
        try {
            this.getCacheManager().evictFeature(featureId);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    public FeatureStore getTargetFeatureStore() {
        if (this.targetFeatureStore == null) {
            throw new IllegalArgumentException("ff4j-core: Target for cache proxy has not been provided");
        }
        return this.targetFeatureStore;
    }

    public PropertyStore getTargetPropertyStore() {
        if (this.targetPropertyStore == null) {
            throw new IllegalArgumentException("ff4j-core: Target for cache proxy has not been provided");
        }
        return this.targetPropertyStore;
    }

    public FF4JCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            throw new IllegalArgumentException("ff4j-core: CacheManager for cache proxy has not been provided but it's required");
        }
        return this.cacheManager;
    }

    public void setCacheManager(FF4JCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean isCached() {
        return true;
    }

    public String getCacheProvider() {
        if (this.cacheManager != null) {
            return this.cacheManager.getCacheProviderName();
        }
        return null;
    }

    public String getCachedTargetStore() {
        return this.getTargetFeatureStore().getClass().getName();
    }

    @Override
    public Map<String, Property<?>> readAllProperties() {
        return this.getTargetPropertyStore().readAllProperties();
    }

    @Override
    public boolean existProperty(String propertyName) {
        try {
            if (this.getCacheManager().getProperty(propertyName) == null) {
                return this.getTargetPropertyStore().existProperty(propertyName);
            }
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
        return true;
    }

    @Override
    public <T> void createProperty(Property<T> property) {
        this.getTargetPropertyStore().createProperty(property);
        try {
            this.getCacheManager().putProperty(property);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public Property<?> readProperty(String name) {
        Property<?> fp = this.getCacheManager().getProperty(name);
        if (null == fp) {
            fp = this.getTargetPropertyStore().readProperty(name);
            try {
                this.getCacheManager().putProperty(fp);
            }
            catch (RuntimeException re) {
                this.getCacheManager().onException(re);
            }
        }
        return fp;
    }

    @Override
    public Property<?> readProperty(String name, Property<?> defaultValue) {
        Property<?> fp = this.getCacheManager().getProperty(name);
        if (null == fp) {
            fp = this.getTargetPropertyStore().readProperty(name, defaultValue);
            try {
                this.getCacheManager().putProperty(fp);
            }
            catch (RuntimeException re) {
                this.getCacheManager().onException(re);
            }
        }
        return fp;
    }

    @Override
    public void updateProperty(String name, String newValue) {
        Property<?> fp = this.getTargetPropertyStore().readProperty(name);
        fp.setValueFromString(newValue);
        this.getTargetPropertyStore().updateProperty(fp);
        try {
            this.getCacheManager().evictProperty(fp.getName());
            this.getCacheManager().putProperty(fp);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public <T> void updateProperty(Property<T> propertyValue) {
        this.getTargetPropertyStore().updateProperty(propertyValue);
        try {
            this.getCacheManager().evictProperty(propertyValue.getName());
            this.getCacheManager().putProperty(propertyValue);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public void deleteProperty(String name) {
        this.getTargetPropertyStore().deleteProperty(name);
        try {
            this.getCacheManager().evictProperty(name);
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.listPropertyNames().isEmpty() && this.readAll().isEmpty();
    }

    @Override
    public Set<String> listPropertyNames() {
        return this.getTargetPropertyStore().listPropertyNames();
    }

    @Override
    public void clear() {
        try {
            this.getCacheManager().clearFeatures();
            this.getCacheManager().clearProperties();
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
        this.getTargetPropertyStore().clear();
        this.getTargetFeatureStore().clear();
    }

    @Override
    public void importProperties(Collection<Property<?>> properties) {
        try {
            this.getCacheManager().clearProperties();
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
        this.getTargetPropertyStore().importProperties(properties);
    }

    @Override
    public void importFeatures(Collection<Feature> features) {
        try {
            this.getCacheManager().clearFeatures();
        }
        catch (RuntimeException re) {
            this.getCacheManager().onException(re);
        }
        this.getTargetFeatureStore().importFeatures(features);
    }

    public void setTargetFeatureStore(FeatureStore targetFeatureStore) {
        this.targetFeatureStore = targetFeatureStore;
    }

    public void setTargetPropertyStore(PropertyStore targetPropertyStore) {
        this.targetPropertyStore = targetPropertyStore;
    }

    public Store2CachePollingScheduler getStore2CachePoller() {
        return this.store2CachePoller;
    }

    public void setStore2CachePoller(Store2CachePollingScheduler store2CachePoller) {
        this.store2CachePoller = store2CachePoller;
    }
}

