/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.io.Serializable;
import java.util.Map;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.cache.InMemoryCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.Property;
import org.ff4j.property.store.PropertyStore;

public class Store2CachePollingWorker
implements Runnable,
Serializable {
    private static final long serialVersionUID = 8252550757489651166L;
    private FeatureStore sourceFeatureStore;
    private PropertyStore sourcePropertyStore;
    private FF4JCacheManager cacheManager;
    private FF4jCacheProxy ff4JCacheProxy;

    public Store2CachePollingWorker(FeatureStore sf, PropertyStore sp, FF4JCacheManager cp) {
        this.sourceFeatureStore = sf;
        this.sourcePropertyStore = sp;
        this.cacheManager = cp;
    }

    public Store2CachePollingWorker(FF4jCacheProxy fcp) {
        this(fcp.getTargetFeatureStore(), fcp.getTargetPropertyStore(), null);
        this.ff4JCacheProxy = fcp;
    }

    @Override
    public void run() {
        try {
            FF4JCacheManager cacheManager = this.ff4JCacheProxy != null ? new InMemoryCacheManager() : this.cacheManager;
            if (this.sourceFeatureStore != null) {
                Map<String, Feature> mapOfFeatures = this.sourceFeatureStore.readAll();
                cacheManager.clearFeatures();
                for (Feature feature : mapOfFeatures.values()) {
                    cacheManager.putFeature(feature);
                }
            }
            if (this.sourcePropertyStore != null) {
                Map<String, Property<?>> mapOfProperties = this.sourcePropertyStore.readAllProperties();
                cacheManager.clearProperties();
                for (Property property : mapOfProperties.values()) {
                    cacheManager.putProperty(property);
                }
            }
            if (this.ff4JCacheProxy != null) {
                this.ff4JCacheProxy.setCacheManager(cacheManager);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

