/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.ff4j.utils.Util;

public final class HourInterval {
    private static final DateFormat SDF_HOUR = new SimpleDateFormat("HH:mm");
    private Calendar from = Calendar.getInstance();
    private Calendar to = Calendar.getInstance();

    public HourInterval() {
    }

    public HourInterval(String expression) {
        Util.assertHasLength(expression);
        String[] bounds = expression.split("-");
        if (bounds.length != 2) {
            throw new IllegalArgumentException("Invalid syntax, expected HH:mm-HH:MM " + expression);
        }
        this.init(bounds[0], bounds[1]);
    }

    public HourInterval(String f, String t) {
        this.init(f, t);
    }

    public HourInterval(Date froms, Date tos) {
        if (froms.before(tos)) {
            this.from.setTime(froms);
            this.to.setTime(tos);
        } else {
            this.from.setTime(tos);
            this.to.setTime(froms);
        }
    }

    public HourInterval(Calendar froms, Calendar tos) {
        this(froms.getTime(), tos.getTime());
    }

    public void init(String f, String t) {
        try {
            this.from.setTime(SDF_HOUR.parse(f));
            this.to.setTime(SDF_HOUR.parse(t));
            if (!this.from.before(this.to)) {
                Calendar cal = this.to;
                this.to = this.from;
                this.from = cal;
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse incoming expressions <" + f + ">, <" + t + ">", e);
        }
    }

    public boolean matches() {
        return this.matches(Calendar.getInstance());
    }

    public boolean matches(Calendar cal) {
        this.from.set(1, cal.get(1));
        this.from.set(6, cal.get(6));
        this.to.set(1, cal.get(1));
        this.to.set(6, cal.get(6));
        return this.from.before(cal) && this.to.after(cal);
    }

    public Calendar getFrom() {
        return this.from;
    }

    public void setFrom(Calendar from) {
        this.from = from;
    }

    public Calendar getTo() {
        return this.to;
    }

    public void setTo(Calendar to) {
        this.to = to;
    }
}

