/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.ff4j.audit.EventBuilder;
import org.ff4j.audit.EventPublisher;
import org.ff4j.audit.proxy.FeatureStoreAuditProxy;
import org.ff4j.audit.proxy.PropertyStoreAuditProxy;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.audit.repository.InMemoryEventRepository;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.InMemoryPropertyStore;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.security.AuthorizationsManager;
import org.ff4j.store.InMemoryFeatureStore;

public class FF4j {
    private final long startTime = System.currentTimeMillis();
    private String version = this.getClass().getPackage().getImplementationVersion();
    private String source = "JAVA_API";
    private FeatureStore fstore = new InMemoryFeatureStore();
    private PropertyStore pStore = new InMemoryPropertyStore();
    private boolean autocreate = false;
    private AuthorizationsManager authorizationsManager = null;
    private boolean enableAudit = false;
    private EventRepository eventRepository = new InMemoryEventRepository();
    private EventPublisher eventPublisher = null;
    private volatile boolean shutdownEventPublisher;
    private boolean initialized = false;
    private ThreadLocal<FlippingExecutionContext> flippingExecutionContext = new ThreadLocal();
    private boolean alterBeanThrowInvocationTargetException = true;

    public FF4j() {
        this.version = this.getClass().getPackage().getImplementationVersion();
        if (null == this.version) {
            this.version = "1.8.x";
        }
    }

    public FF4j(String xmlFile) {
        this();
        this.fstore = new InMemoryFeatureStore(xmlFile);
        this.pStore = new InMemoryPropertyStore(xmlFile);
    }

    public FF4j(InputStream xmlFileResourceAsStream) {
        this();
        this.fstore = new InMemoryFeatureStore(xmlFileResourceAsStream);
    }

    public boolean check(String featureID) {
        return this.check(featureID, this.flippingExecutionContext.get());
    }

    public boolean check(String featureID, FlippingExecutionContext executionContext) {
        Feature fp = this.getFeature(featureID);
        boolean flipped = fp.isEnable();
        if (flipped && this.getAuthorizationsManager() != null) {
            flipped = this.isAllowed(fp);
        }
        if (flipped && fp.getFlippingStrategy() != null) {
            flipped = fp.getFlippingStrategy().evaluate(featureID, this.getFeatureStore(), executionContext);
        }
        this.flippingExecutionContext.set(executionContext);
        this.publishCheck(featureID, flipped);
        return flipped;
    }

    private void publishCheck(String uid, boolean checked) {
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(new EventBuilder(this).feature(uid).action(checked ? "checkOn" : "checkOff").build());
        }
    }

    public boolean checkOveridingStrategy(String featureID, FlippingStrategy strats) {
        return this.checkOveridingStrategy(featureID, strats, this.flippingExecutionContext.get());
    }

    public boolean checkOveridingStrategy(String featureID, FlippingStrategy strats, FlippingExecutionContext executionContext) {
        boolean flipped;
        Feature fp = this.getFeature(featureID);
        boolean bl = flipped = fp.isEnable() && this.isAllowed(fp);
        if (strats != null) {
            flipped = flipped && strats.evaluate(featureID, this.getFeatureStore(), executionContext);
        }
        this.publishCheck(featureID, flipped);
        return flipped;
    }

    public boolean isAllowed(Feature feature) {
        return this.getAuthorizationsManager() == null || feature.getPermissions().isEmpty() || this.getAuthorizationsManager().isAllowed(feature.getPermissions());
    }

    public Map<String, Feature> getFeatures() {
        return this.getFeatureStore().readAll();
    }

    public Map<String, Property<?>> getProperties() {
        return this.getPropertiesStore().readAllProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FF4j enable(String featureID) {
        try {
            this.getFeatureStore().enable(featureID);
        }
        catch (FeatureNotFoundException fnfe) {
            if (this.autocreate) {
                FF4j fF4j = this;
                synchronized (fF4j) {
                    if (!this.getFeatureStore().exist(featureID)) {
                        this.getFeatureStore().create(new Feature(featureID, true));
                    }
                }
            }
            throw fnfe;
        }
        return this;
    }

    public FF4j enableGroup(String groupName) {
        this.getFeatureStore().enableGroup(groupName);
        return this;
    }

    public FF4j disableGroup(String groupName) {
        this.getFeatureStore().disableGroup(groupName);
        return this;
    }

    public FF4j createFeature(Feature fp) {
        this.getFeatureStore().create(fp);
        return this;
    }

    public FF4j createProperty(Property<?> prop) {
        this.getPropertiesStore().createProperty(prop);
        return this;
    }

    public FF4j createFeature(String featureName, boolean enable, String description) {
        return this.createFeature(new Feature(featureName, enable, description));
    }

    public FF4j createFeature(String featureName, boolean enable) {
        return this.createFeature(featureName, enable, "");
    }

    public FF4j createFeature(String featureName) {
        return this.createFeature(featureName, false, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FF4j disable(String featureID) {
        try {
            this.getFeatureStore().disable(featureID);
        }
        catch (FeatureNotFoundException fnfe) {
            if (this.autocreate) {
                FF4j fF4j = this;
                synchronized (fF4j) {
                    if (!this.getFeatureStore().exist(featureID)) {
                        this.getFeatureStore().create(new Feature(featureID, false));
                    }
                }
            }
            throw fnfe;
        }
        return this;
    }

    public boolean exist(String featureId) {
        return this.getFeatureStore().exist(featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getFeature(String featureID) {
        Feature fp = null;
        try {
            fp = this.getFeatureStore().read(featureID);
        }
        catch (FeatureNotFoundException fnfe) {
            if (this.autocreate) {
                FF4j fF4j = this;
                synchronized (fF4j) {
                    if (!this.getFeatureStore().exist(featureID)) {
                        fp = new Feature(featureID, false);
                        this.getFeatureStore().create(fp);
                    } else {
                        fp = this.getFeatureStore().read(featureID);
                    }
                }
            }
            throw fnfe;
        }
        return fp;
    }

    public Property<?> getProperty(String propertyName) {
        return this.getPropertiesStore().readProperty(propertyName);
    }

    public String getPropertyAsString(String propertyName) {
        return this.getProperty(propertyName).asString();
    }

    public FF4j importFeatures(Collection<Feature> features) {
        this.getFeatureStore().importFeatures(features);
        return this;
    }

    public FF4j importProperties(Collection<Property<?>> properties) {
        if (properties != null) {
            for (Property<?> property : properties) {
                this.getPropertiesStore().createProperty(property);
            }
        }
        return this;
    }

    public InputStream exportFeatures() throws IOException {
        return new XmlParser().exportFeatures(this.getFeatureStore().readAll());
    }

    public FF4j autoCreate(boolean flag) {
        this.setAutocreate(flag);
        return this;
    }

    public FF4j autoCreate() {
        return this.autoCreate(true);
    }

    public FF4j audit() {
        return this.audit(true);
    }

    public FF4j audit(boolean val) {
        this.setEnableAudit(val);
        return this;
    }

    public FF4j delete(String fpId) {
        this.getFeatureStore().delete(fpId);
        return this;
    }

    public FF4j deleteProperty(String propertyName) {
        this.getPropertiesStore().deleteProperty(propertyName);
        return this;
    }

    public FF4j cache(FF4JCacheManager cm) {
        FF4jCacheProxy cp = new FF4jCacheProxy(this.getFeatureStore(), this.getPropertiesStore(), cm);
        this.setFeatureStore(cp);
        this.setPropertiesStore(cp);
        return this;
    }

    public XmlConfig parseXmlConfig(String fileName) {
        InputStream xmlIN = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (xmlIN == null) {
            throw new IllegalArgumentException("Cannot parse XML file " + fileName + " - file not found");
        }
        return new XmlParser().parseConfigurationFile(xmlIN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        long uptime = System.currentTimeMillis() - this.startTime;
        long daynumber = uptime / 86400000L;
        long hourNumber = (uptime -= daynumber * 1000L * 3600L * 24L) / 3600000L;
        long minutenumber = (uptime -= hourNumber * 1000L * 3600L) / 60000L;
        long secondnumber = (uptime -= minutenumber * 1000L * 60L) / 1000L;
        sb.append("\"uptime\":\"");
        sb.append(daynumber + " day(s) ");
        sb.append(hourNumber + " hours(s) ");
        sb.append(minutenumber + " minute(s) ");
        sb.append(secondnumber + " seconds\"");
        sb.append(", \"autocreate\":" + this.isAutocreate());
        sb.append(", \"version\": \"" + this.version + "\"");
        if (this.getFeatureStore() != null) {
            sb.append(", \"featuresStore\":");
            sb.append(this.getFeatureStore().toString());
        }
        if (this.getPropertiesStore() != null) {
            sb.append(", \"propertiesStore\":");
            sb.append(this.getPropertiesStore().toString());
        }
        if (this.getEventRepository() != null) {
            sb.append(", \"eventRepository\":");
            sb.append(this.getEventRepository().toString());
        }
        if (this.getAuthorizationsManager() != null) {
            sb.append(", \"authorizationsManager\":");
            sb.append(this.getAuthorizationsManager().toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public void setFeatureStore(FeatureStore fbs) {
        this.fstore = fbs;
    }

    public void setAutocreate(boolean autocreate) {
        this.autocreate = autocreate;
    }

    public AuthorizationsManager getAuthorizationsManager() {
        return this.authorizationsManager;
    }

    public void setAuthorizationsManager(AuthorizationsManager authorizationsManager) {
        this.authorizationsManager = authorizationsManager;
    }

    public EventRepository getEventRepository() {
        return this.eventRepository;
    }

    public void setEventRepository(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private synchronized void init() {
        FlippingExecutionContext context = new FlippingExecutionContext();
        this.flippingExecutionContext.set(context);
        if (this.eventPublisher == null) {
            this.eventPublisher = new EventPublisher(this.eventRepository);
            this.shutdownEventPublisher = true;
        }
        if (this.isEnableAudit()) {
            if (this.fstore != null && !(this.fstore instanceof FeatureStoreAuditProxy)) {
                this.fstore = new FeatureStoreAuditProxy(this, this.fstore);
            }
            if (this.pStore != null && !(this.pStore instanceof PropertyStoreAuditProxy)) {
                this.pStore = new PropertyStoreAuditProxy(this, this.pStore);
            }
        } else {
            if (this.fstore != null && this.fstore instanceof FeatureStoreAuditProxy) {
                this.fstore = ((FeatureStoreAuditProxy)this.fstore).getTarget();
            }
            if (this.pStore != null && this.pStore instanceof PropertyStoreAuditProxy) {
                this.pStore = ((PropertyStoreAuditProxy)this.pStore).getTarget();
            }
        }
        this.initialized = true;
    }

    public void createSchema() {
        if (null != this.getFeatureStore()) {
            this.getFeatureStore().createSchema();
        }
        if (null != this.getPropertiesStore()) {
            this.getPropertiesStore().createSchema();
        }
        if (null != this.getEventRepository()) {
            this.getEventRepository().createSchema();
        }
    }

    public FeatureStore getFeatureStore() {
        if (!this.initialized) {
            this.init();
        }
        return this.fstore;
    }

    public EventPublisher getEventPublisher() {
        if (!this.initialized) {
            this.init();
        }
        return this.eventPublisher;
    }

    public PropertyStore getPropertiesStore() {
        if (!this.initialized) {
            this.init();
        }
        return this.pStore;
    }

    public FlippingExecutionContext getCurrentContext() {
        if (!this.initialized) {
            this.init();
        }
        if (null == this.flippingExecutionContext.get()) {
            this.flippingExecutionContext.set(new FlippingExecutionContext());
        }
        return this.flippingExecutionContext.get();
    }

    public void setCurrentContext(FlippingExecutionContext executionContext) {
        this.flippingExecutionContext.set(executionContext);
    }

    public boolean isAutocreate() {
        return this.autocreate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setPropertiesStore(PropertyStore pStore) {
        this.pStore = pStore;
    }

    public void removeCurrentContext() {
        this.flippingExecutionContext.remove();
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
        this.initialized = false;
    }

    public void setFileName(String fname) {
    }

    public void setAuthManager(String mnger) {
    }

    public void stop() {
        if (this.eventPublisher != null && this.shutdownEventPublisher) {
            this.eventPublisher.stop();
        }
    }

    public String getSource() {
        return this.source;
    }

    public FeatureStore getConcreteFeatureStore() {
        return this.getConcreteFeatureStore(this.getFeatureStore());
    }

    public PropertyStore getConcretePropertyStore() {
        return this.getConcretePropertyStore(this.getPropertiesStore());
    }

    public FF4jCacheProxy getCacheProxy() {
        FeatureStore fs = this.getFeatureStore();
        if (fs instanceof FeatureStoreAuditProxy) {
            fs = ((FeatureStoreAuditProxy)fs).getTarget();
        }
        if (fs instanceof FF4jCacheProxy) {
            return (FF4jCacheProxy)fs;
        }
        return null;
    }

    private FeatureStore getConcreteFeatureStore(FeatureStore fs) {
        if (fs instanceof FeatureStoreAuditProxy) {
            return this.getConcreteFeatureStore(((FeatureStoreAuditProxy)fs).getTarget());
        }
        if (fs instanceof FF4jCacheProxy) {
            return this.getConcreteFeatureStore(((FF4jCacheProxy)fs).getTargetFeatureStore());
        }
        return fs;
    }

    private PropertyStore getConcretePropertyStore(PropertyStore ps) {
        if (ps instanceof PropertyStoreAuditProxy) {
            return this.getConcretePropertyStore(((PropertyStoreAuditProxy)ps).getTarget());
        }
        if (ps instanceof FF4jCacheProxy) {
            return this.getConcretePropertyStore(((FF4jCacheProxy)ps).getTargetPropertyStore());
        }
        return ps;
    }

    public void enableAlterBeanThrowInvocationTargetException() {
        this.alterBeanThrowInvocationTargetException = true;
    }

    public void disableAlterBeanThrowInvocationTargetException() {
        this.alterBeanThrowInvocationTargetException = false;
    }

    public boolean isAlterBeanThrowInvocationTargetException() {
        return this.alterBeanThrowInvocationTargetException;
    }

    public void setFlippingExecutionContext(ThreadLocal<FlippingExecutionContext> flippingExecutionContext) {
        this.flippingExecutionContext = flippingExecutionContext;
    }
}

