/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.ff4j.audit.Event;
import org.ff4j.utils.TimeUtils;
import org.ff4j.utils.Util;

public class EventQueryDefinition
implements Serializable {
    private static final long serialVersionUID = -1649081647715140190L;
    private int maxresult;
    private boolean pageable = false;
    private int pagenumber = 0;
    private int pagesize = 0;
    private long from = TimeUtils.getTodayMidnightTime();
    private long to = TimeUtils.getTomorrowMidnightTime();
    private Set<String> namesFilter = new HashSet<String>();
    private Set<String> actionFilters = new HashSet<String>();
    private Set<String> sourceFilters = new HashSet<String>();
    private Set<String> hostFilters = new HashSet<String>();

    public EventQueryDefinition() {
    }

    public EventQueryDefinition(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public EventQueryDefinition addFilterName(String name) {
        this.namesFilter.add(name);
        return this;
    }

    public EventQueryDefinition addFilterAction(String action) {
        this.actionFilters.add(action);
        return this;
    }

    public EventQueryDefinition addFilterSource(String source) {
        this.sourceFilters.add(source);
        return this;
    }

    public EventQueryDefinition addFilterHost(String host) {
        this.hostFilters.add(host);
        return this;
    }

    public boolean match(Event evt) {
        return evt.getTimestamp() >= this.from && evt.getTimestamp() <= this.to && this.matchAction(evt.getAction()) && this.matchSource(evt.getSource()) && this.matchHost(evt.getHostName()) && this.matchName(evt.getName());
    }

    public boolean matchAction(String action) {
        return this.actionFilters.isEmpty() || Util.hasLength(action) && this.actionFilters.contains(action);
    }

    public boolean matchSource(String source) {
        return this.sourceFilters.isEmpty() || Util.hasLength(source) && this.sourceFilters.contains(source);
    }

    public boolean matchHost(String host) {
        return this.hostFilters.isEmpty() || Util.hasLength(host) && this.hostFilters.contains(host);
    }

    public boolean matchName(String name) {
        return this.namesFilter.isEmpty() || Util.hasLength(name) && this.namesFilter.contains(name);
    }

    public Long getFrom() {
        return this.from;
    }

    public void setFrom(Long from) {
        this.from = from;
    }

    public Long getTo() {
        return this.to;
    }

    public void setTo(Long to) {
        this.to = to;
    }

    public Set<String> getNamesFilter() {
        return this.namesFilter;
    }

    public void setNamesFilter(Set<String> namesFilter) {
        this.namesFilter = namesFilter;
    }

    public Set<String> getActionFilters() {
        return this.actionFilters;
    }

    public void setActionFilters(Set<String> actionFilters) {
        this.actionFilters = actionFilters;
    }

    public Set<String> getSourceFilters() {
        return this.sourceFilters;
    }

    public void setSourceFilters(Set<String> sourceFilters) {
        this.sourceFilters = sourceFilters;
    }

    public Set<String> getHostFilters() {
        return this.hostFilters;
    }

    public void setHostFilters(Set<String> hostFilters) {
        this.hostFilters = hostFilters;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public int getMaxresult() {
        return this.maxresult;
    }

    public void setMaxresult(int maxresult) {
        this.maxresult = maxresult;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public void setPageable(boolean pageable) {
        this.pageable = pageable;
    }

    public int getPagenumber() {
        return this.pagenumber;
    }

    public void setPagenumber(int pagenumber) {
        this.pagenumber = pagenumber;
    }

    public int getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(int pagesize) {
        this.pagesize = pagesize;
    }
}

