/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.proxy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ff4j.FF4j;
import org.ff4j.audit.EventBuilder;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;

public class FeatureStoreAuditProxy
implements FeatureStore {
    private FeatureStore target = null;
    private FF4j ff4j = null;

    public FeatureStoreAuditProxy(FF4j pFF4j, FeatureStore pTarget) {
        this.target = pTarget;
        this.ff4j = pFF4j;
    }

    @Override
    public void createSchema() {
        this.target.createSchema();
        this.publish(this.builder("create-schema").feature("For Features"));
    }

    @Override
    public void enable(String uid) {
        long start = System.nanoTime();
        this.target.enable(uid);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("toggle-on").feature(uid).duration(duration));
    }

    @Override
    public void disable(String uid) {
        long start = System.nanoTime();
        this.target.disable(uid);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("toggle-off").feature(uid).duration(duration));
    }

    @Override
    public void create(Feature fp) {
        long start = System.nanoTime();
        this.target.create(fp);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("create").feature(fp.getUid()).duration(duration));
    }

    @Override
    public void delete(String uid) {
        long start = System.nanoTime();
        this.target.delete(uid);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("delete").feature(uid).duration(duration));
    }

    @Override
    public void update(Feature fp) {
        long start = System.nanoTime();
        this.target.update(fp);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("update").feature(fp.getUid()).duration(duration));
    }

    @Override
    public void grantRoleOnFeature(String uid, String roleName) {
        long start = System.nanoTime();
        this.target.grantRoleOnFeature(uid, roleName);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("GRANT ROLE " + roleName).feature(uid).duration(duration));
    }

    @Override
    public void removeRoleFromFeature(String uid, String roleName) {
        long start = System.nanoTime();
        this.target.removeRoleFromFeature(uid, roleName);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("REMOVE ROLE " + roleName).feature(uid).duration(duration));
    }

    @Override
    public void enableGroup(String groupName) {
        long start = System.nanoTime();
        this.target.enableGroup(groupName);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("toggle-on").group(groupName).duration(duration));
    }

    @Override
    public void disableGroup(String groupName) {
        long start = System.nanoTime();
        this.target.disableGroup(groupName);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("toggle-off").group(groupName).duration(duration));
    }

    @Override
    public void addToGroup(String uid, String groupName) {
        long start = System.nanoTime();
        this.target.addToGroup(uid, groupName);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("ADD TO GROUP " + groupName).feature(uid).duration(duration));
    }

    @Override
    public void removeFromGroup(String uid, String groupName) {
        long start = System.nanoTime();
        this.target.removeFromGroup(uid, groupName);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("ADD TO GROUP " + groupName).feature(uid).duration(duration));
    }

    @Override
    public void clear() {
        long start = System.nanoTime();
        this.target.clear();
        long duration = System.nanoTime() - start;
        this.publish(this.builder("clear").type("featureStore").name(this.ff4j.getFeatureStore().getClass().getName()).duration(duration));
    }

    private EventBuilder builder(String action) {
        return new EventBuilder(this.ff4j).type("feature").action(action);
    }

    private void publish(EventBuilder eb) {
        this.ff4j.getEventPublisher().publish(eb.build());
    }

    @Override
    public boolean exist(String uid) {
        return this.target.exist(uid);
    }

    @Override
    public Feature read(String uid) {
        return this.target.read(uid);
    }

    @Override
    public Map<String, Feature> readAll() {
        return this.target.readAll();
    }

    @Override
    public boolean existGroup(String groupName) {
        return this.target.existGroup(groupName);
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        return this.target.readGroup(groupName);
    }

    @Override
    public Set<String> readAllGroups() {
        return this.target.readAllGroups();
    }

    @Override
    public void importFeatures(Collection<Feature> features) {
        if (features != null) {
            for (Feature feature : features) {
                if (this.exist(feature.getUid())) {
                    this.delete(feature.getUid());
                }
                this.create(feature);
            }
        }
    }

    public FeatureStore getTarget() {
        return this.target;
    }
}

