/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.cache.Store2CachePollingWorker;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.store.PropertyStore;

public class Store2CachePollingScheduler
implements Serializable {
    private static final long serialVersionUID = -1198719730422859724L;
    private long pollingDelay = 10000L;
    private long initialDelay = 0L;
    private ScheduledExecutorService executor;
    private Store2CachePollingWorker worker;

    public Store2CachePollingScheduler(FeatureStore sf, PropertyStore sp, FF4JCacheManager cp) {
        this.worker = new Store2CachePollingWorker(sf, sp, cp);
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "FF4j_Store2CachePollingWorker");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public Store2CachePollingScheduler(FF4jCacheProxy fcp) {
        this.worker = new Store2CachePollingWorker(fcp);
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "FF4j_Store2CachePollingWorker");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public void start(long delay) {
        this.pollingDelay = delay;
        this.start();
    }

    public void start() {
        this.executor.scheduleWithFixedDelay(this.worker, this.initialDelay, this.pollingDelay, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public long getPollingDelay() {
        return this.pollingDelay;
    }

    public void setPollingDelay(long pollingDelay) {
        this.pollingDelay = pollingDelay;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }
}

