/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.AbstractConnectionPool;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.FBPooledConnection;
import org.firebirdsql.pool.FBPooledDataSourceFactory;
import org.firebirdsql.pool.FirebirdPool;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionManager;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledObjectEvent;

@Deprecated
public abstract class AbstractFBConnectionPoolDataSource
extends BasicAbstractConnectionPool
implements ConnectionPoolDataSource,
XADataSource,
PooledConnectionEventListener,
FirebirdPool {
    public static final AbstractConnectionPool.UserPasswordPair EMPTY_USER_PASSWORD = new AbstractConnectionPool.UserPasswordPair();
    private static final String PING_STATEMENT = "SELECT cast(1 AS INTEGER) FROM rdb$database";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFBConnectionPoolDataSource.class, false);
    private transient PrintWriter logWriter;
    private volatile transient FBManagedConnectionFactory mcf;
    private FBConnectionProperties connectionProperties = new FBConnectionProperties();
    protected static final String REF_PROPERTIES = "properties";
    protected static final String REF_NON_STANDARD_PROPERTY = "nonStandard";

    public FBConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(FBConnectionProperties props) {
        if (props == null) {
            throw new NullPointerException();
        }
        this.checkNotStarted();
        this.connectionProperties = props;
    }

    private void checkNotStarted() throws IllegalStateException {
        if (this.mcf != null) {
            throw new IllegalStateException("ManagedConnectionFactory is already instantiated, changing connection properties in bulk is not allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FBManagedConnectionFactory getManagedConnectionFactory() {
        if (this.mcf != null) {
            return this.mcf;
        }
        AbstractFBConnectionPoolDataSource abstractFBConnectionPoolDataSource = this;
        synchronized (abstractFBConnectionPoolDataSource) {
            if (this.mcf != null) {
                return this.mcf;
            }
            GDSType gdsType = GDSType.getType(this.getType());
            if (gdsType == null) {
                gdsType = GDSFactory.getDefaultGDSType();
            }
            this.mcf = new FBManagedConnectionFactory(gdsType, this.connectionProperties);
        }
        return this.mcf;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected PooledConnectionManager getConnectionManager() {
        return new PooledConnectionManagerImpl(this.getManagedConnectionFactory());
    }

    @Override
    protected String getPoolName() {
        return this.getDatabase();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public int getLoginTimeout() {
        return this.getBlockingTimeout() / 1000;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    @Override
    protected PooledObject getPooledConnection(PooledConnectionQueue queue) throws SQLException {
        FBPooledConnection connection = (FBPooledConnection)super.getPooledConnection(queue);
        connection.addConnectionEventListener(this);
        connection.setManagedEnvironment(false);
        return connection;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(EMPTY_USER_PASSWORD)));
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(new AbstractConnectionPool.UserPasswordPair(user, password))));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        FBPooledConnection result = (FBPooledConnection)this.getPooledConnection();
        result.setManagedEnvironment(true);
        return result;
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        FBPooledConnection result = (FBPooledConnection)this.getPooledConnection(user, password);
        result.setManagedEnvironment(true);
        return result;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource());
        this.pooledObjectReleased(event);
    }

    @Override
    public void physicalConnectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.pooledObjectReleased(event);
    }

    @Override
    public void physicalConnectionDeallocated(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.physicalConnectionDeallocated(event);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.getLogger() != null) {
            this.getLogger().error("Error occured in connection.", event.getSQLException());
        }
    }

    @Override
    public int getFreeSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).size();
    }

    @Override
    public int getTotalSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).totalSize();
    }

    @Override
    public int getWorkingSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).workingSize();
    }

    @Override
    public boolean isPingable() {
        return true;
    }

    @Override
    public String getPingStatement() {
        String pingStatement = super.getPingStatement();
        if (pingStatement != null) {
            return pingStatement;
        }
        return PING_STATEMENT;
    }

    public void setProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setNonStandardProperty(key, value);
        }
    }

    @Override
    public String getType() {
        return this.connectionProperties.getType();
    }

    @Override
    public void setType(String type) {
        this.checkNotStarted();
        this.connectionProperties.setType(type);
    }

    public GDSType getGDSType() {
        return GDSType.getType(this.getType());
    }

    public void setGDSType(GDSType gdsType) {
        this.checkNotStarted();
        this.setType(gdsType.toString());
    }

    @Override
    public String getNonStandardProperty(String key) {
        return this.connectionProperties.getNonStandardProperty(key);
    }

    @Override
    public void setNonStandardProperty(String key, String value) {
        this.checkNotStarted();
        this.connectionProperties.setNonStandardProperty(key, value);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.checkNotStarted();
        this.connectionProperties.setNonStandardProperty(propertyMapping);
    }

    @Override
    public int getBlobBufferSize() {
        return this.connectionProperties.getBlobBufferSize();
    }

    @Override
    public void setBlobBufferSize(int blobBufferSize) {
        this.checkNotStarted();
        this.connectionProperties.setBlobBufferSize(blobBufferSize);
    }

    @Override
    public String getEncoding() {
        return this.connectionProperties.getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        this.checkNotStarted();
        this.connectionProperties.setEncoding(encoding);
    }

    @Override
    public String getCharSet() {
        return this.connectionProperties.getCharSet();
    }

    @Override
    public void setCharSet(String charSet) {
        this.checkNotStarted();
        this.connectionProperties.setCharSet(charSet);
    }

    @Override
    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.checkNotStarted();
        this.connectionProperties.setPassword(password);
    }

    @Override
    public int getSocketBufferSize() {
        this.checkNotStarted();
        return this.connectionProperties.getSocketBufferSize();
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.checkNotStarted();
        this.connectionProperties.setSocketBufferSize(socketBufferSize);
    }

    @Override
    public String getRoleName() {
        return this.connectionProperties.getRoleName();
    }

    @Override
    public void setRoleName(String roleName) {
        this.checkNotStarted();
        this.connectionProperties.setRoleName(roleName);
    }

    public String getSqlRole() {
        return this.getRoleName();
    }

    public void setSqlRole(String sqlRole) {
        this.setRoleName(sqlRole);
    }

    @Override
    public String getTpbMapping() {
        return this.connectionProperties.getTpbMapping();
    }

    @Override
    public void setTpbMapping(String tpbMapping) {
        this.checkNotStarted();
        this.connectionProperties.setTpbMapping(tpbMapping);
    }

    @Override
    public String getUserName() {
        return this.connectionProperties.getUserName();
    }

    @Override
    public void setUserName(String userName) {
        this.checkNotStarted();
        this.connectionProperties.setUserName(userName);
    }

    @Override
    public int getBuffersNumber() {
        return this.connectionProperties.getBlobBufferSize();
    }

    @Override
    public String getDatabase() {
        return this.connectionProperties.getDatabase();
    }

    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.connectionProperties.getDatabaseParameterBuffer();
    }

    @Override
    public String getDefaultIsolation() {
        return this.connectionProperties.getDefaultIsolation();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.connectionProperties.getDefaultTransactionIsolation();
    }

    @Override
    public String getSqlDialect() {
        return this.connectionProperties.getSqlDialect();
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    @Override
    public String getUseTranslation() {
        return this.connectionProperties.getUseTranslation();
    }

    @Override
    public boolean isTimestampUsesLocalTimezone() {
        return this.connectionProperties.isTimestampUsesLocalTimezone();
    }

    @Override
    public boolean isUseStandardUdf() {
        return this.connectionProperties.isUseStandardUdf();
    }

    @Override
    public boolean isUseStreamBlobs() {
        return this.connectionProperties.isUseStreamBlobs();
    }

    @Override
    public void setBuffersNumber(int buffersNumber) {
        this.checkNotStarted();
        this.connectionProperties.setBuffersNumber(buffersNumber);
    }

    @Override
    public void setDatabase(String database) {
        this.checkNotStarted();
        this.connectionProperties.setDatabase(database);
    }

    @Override
    public void setDefaultIsolation(String isolation) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultIsolation(isolation);
    }

    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    @Override
    public void setSqlDialect(String sqlDialect) {
        this.checkNotStarted();
        this.connectionProperties.setSqlDialect(sqlDialect);
    }

    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.checkNotStarted();
        this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.checkNotStarted();
        this.connectionProperties.setTransactionParameters(isolation, tpb);
    }

    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        this.checkNotStarted();
        this.connectionProperties.setUseStandardUdf(useStandardUdf);
    }

    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.checkNotStarted();
        this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
    }

    @Override
    public void setUseTranslation(String translationPath) {
        this.checkNotStarted();
        this.connectionProperties.setUseTranslation(translationPath);
    }

    @Override
    public boolean isDefaultResultSetHoldable() {
        return this.connectionProperties.isDefaultResultSetHoldable();
    }

    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
    }

    @Override
    public int getSoTimeout() {
        this.checkNotStarted();
        return this.connectionProperties.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.checkNotStarted();
        this.connectionProperties.setSoTimeout(soTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.connectionProperties.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.checkNotStarted();
        this.connectionProperties.setConnectTimeout(connectTimeout);
    }

    @Override
    public boolean isUseFirebirdAutocommit() {
        return this.connectionProperties.isUseFirebirdAutocommit();
    }

    @Override
    public void setUseFirebirdAutocommit(boolean useFirebirdAutocommit) {
        this.checkNotStarted();
        this.connectionProperties.setUseFirebirdAutocommit(useFirebirdAutocommit);
    }

    @Override
    public Reference getDefaultReference() {
        Reference ref = super.getDefaultReference();
        byte[] data = AbstractFBConnectionPoolDataSource.serialize(this.connectionProperties);
        ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        return ref;
    }

    protected Object processObjectInstance(AbstractFBConnectionPoolDataSource ds, Reference ref) throws Exception {
        if (ds == null) {
            return null;
        }
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr element = ref.get(i);
            String type = element.getType();
            if (REF_NON_STANDARD_PROPERTY.equals(type)) {
                ds.setNonStandardProperty(element.getContent().toString());
                continue;
            }
            if (REF_PROPERTIES.equals(type)) {
                byte[] data = (byte[])element.getContent();
                FBConnectionProperties props = (FBConnectionProperties)AbstractFBConnectionPoolDataSource.deserialize(data);
                ds.setConnectionProperties(props);
                continue;
            }
            if (!(element.getContent() instanceof String)) continue;
            ds.setNonStandardProperty(type, element.getContent().toString());
        }
        return ds;
    }

    @Override
    protected BasicAbstractConnectionPool createObjectInstance() {
        return FBPooledDataSourceFactory.createFBConnectionPoolDataSource();
    }

    private class PooledConnectionManagerImpl
    implements PooledConnectionManager {
        private final WeakReference<FBManagedConnectionFactory> mcf;

        private PooledConnectionManagerImpl(FBManagedConnectionFactory mcf) {
            this.mcf = new WeakReference<FBManagedConnectionFactory>(mcf);
        }

        @Override
        public PooledObject allocateConnection(Object key, PooledConnectionQueue queue) throws SQLException {
            if (!(key instanceof AbstractConnectionPool.UserPasswordPair)) {
                throw new SQLException("Incorrect key.");
            }
            AbstractConnectionPool.UserPasswordPair pair = (AbstractConnectionPool.UserPasswordPair)key;
            FBManagedConnectionFactory connectionFactory = (FBManagedConnectionFactory)this.mcf.get();
            if (connectionFactory == null) {
                throw new SQLException("Weak reference to connection factory is null. Underlying connection pool has not been initialized or has been closed.");
            }
            String userName = pair.getUserName();
            String password = pair.getPassword();
            try {
                FBConnectionRequestInfo defaultCri = connectionFactory.getDefaultConnectionRequestInfo();
                if (userName != null) {
                    defaultCri.setUserName(userName);
                }
                if (password != null) {
                    defaultCri.setPassword(password);
                }
                FBManagedConnection managedConnection = (FBManagedConnection)connectionFactory.createManagedConnection(null, defaultCri);
                managedConnection.setConnectionSharing(false);
                managedConnection.setManagedEnvironment(false);
                FBPooledConnection pooledConnection = AbstractFBConnectionPoolDataSource.this.isPingable() ? new FBPooledConnection(managedConnection, defaultCri, AbstractFBConnectionPoolDataSource.this.getPingStatement(), AbstractFBConnectionPoolDataSource.this.getPingInterval(), AbstractFBConnectionPoolDataSource.this.isStatementPooling(), AbstractFBConnectionPoolDataSource.this.getMaxStatements(), AbstractFBConnectionPoolDataSource.this.isKeepStatements(), queue) : new FBPooledConnection(managedConnection, defaultCri, AbstractFBConnectionPoolDataSource.this.isStatementPooling(), AbstractFBConnectionPoolDataSource.this.getMaxStatements(), AbstractFBConnectionPoolDataSource.this.isKeepStatements(), queue);
                return pooledConnection;
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }
    }
}

