/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBDriver;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;
import org.firebirdsql.jdbc.FirebirdDriver;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractDriver
implements FirebirdDriver {
    private static final Logger log;
    public static final String CHARSET = "charSet";
    public static final String USE_TRANSLATION = "useTranslation";
    public static final String USER = "user";
    public static final String USER_NAME = "user_name";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String BLOB_BUFFER_LENGTH = "blob_buffer_length";
    public static final String TPB_MAPPING = "tpb_mapping";
    private final Map<FBConnectionProperties, SoftReference<FBDataSource>> mcfToDataSourceMap = new ConcurrentHashMap<FBConnectionProperties, SoftReference<FBDataSource>>();
    private final ReferenceQueue<FBDataSource> dataSourceReferenceQueue = new ReferenceQueue();
    private final Object createDataSourceLock = new Object();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        GDSType type = GDSFactory.getTypeForProtocol(url);
        if (type == null) {
            return null;
        }
        Properties mergedProperties = AbstractDriver.mergeProperties(url, info);
        Map<String, String> normalizedInfo = FBDriverPropertyManager.normalize(url, mergedProperties);
        try {
            int qMarkIndex = url.indexOf(63);
            if (qMarkIndex != -1) {
                url = url.substring(0, qMarkIndex);
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            String databaseURL = GDSFactory.getDatabasePath(type, url);
            mcf.setDatabase(databaseURL);
            Iterator<Map.Entry<String, String>> iterator = normalizedInfo.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> o;
                Map.Entry<String, String> entry = o = iterator.next();
                mcf.setNonStandardProperty(entry.getKey(), entry.getValue());
            }
            FBConnectionHelper.processTpbMapping(mcf.getGDS(), mcf, mergedProperties);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return dataSource.getConnection(mcf.getUserName(), mcf.getPassword());
        }
        catch (ResourceException resex) {
            throw new FBSQLException(resex);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FBDataSource createDataSource(FBManagedConnectionFactory mcf) throws ResourceException {
        FBConnectionProperties cacheKey = mcf.getCacheKey();
        FBDataSource dataSource = this.dataSourceFromCache(cacheKey);
        if (dataSource != null) {
            return dataSource;
        }
        Object object = this.createDataSourceLock;
        synchronized (object) {
            dataSource = this.dataSourceFromCache(cacheKey);
            if (dataSource == null) {
                dataSource = (FBDataSource)mcf.createConnectionFactory();
                this.mcfToDataSourceMap.put(cacheKey, new SoftReference<FBDataSource>(dataSource, this.dataSourceReferenceQueue));
            }
        }
        this.cleanDataSourceCache();
        return dataSource;
    }

    private void cleanDataSourceCache() {
        Reference<FBDataSource> reference;
        while ((reference = this.dataSourceReferenceQueue.poll()) != null) {
            this.mcfToDataSourceMap.values().remove(reference);
        }
    }

    private FBDataSource dataSourceFromCache(FBConnectionProperties cacheKey) {
        SoftReference<FBDataSource> dataSourceReference = this.mcfToDataSourceMap.get(cacheKey);
        return dataSourceReference != null ? dataSourceReference.get() : null;
    }

    @Override
    public FirebirdConnection connect(FirebirdConnectionProperties properties) throws SQLException {
        GDSType type = GDSType.getType(properties.getType());
        if (type == null) {
            type = GDSFactory.getDefaultGDS().getType();
        }
        try {
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return (FirebirdConnection)dataSource.getConnection(mcf.getUserName(), mcf.getPassword());
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public FirebirdConnectionProperties newConnectionProperties() {
        return new FBConnectionProperties();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        Set protocols = GDSFactory.getSupportedProtocols();
        for (String protocol : protocols) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return FBDriverPropertyManager.getDriverPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private static Properties mergeProperties(String jdbcUrl, Properties connectionProperties) {
        Properties mergedProperties = new Properties();
        if (connectionProperties != null) {
            for (String propertyName : connectionProperties.stringPropertyNames()) {
                mergedProperties.setProperty(propertyName, connectionProperties.getProperty(propertyName));
            }
        }
        AbstractDriver.convertUrlParams(jdbcUrl, mergedProperties);
        return mergedProperties;
    }

    private static void convertUrlParams(String url, Properties info) {
        if (url == null) {
            return;
        }
        int iQuestionMark = url.indexOf("?");
        if (iQuestionMark == -1) {
            return;
        }
        String propString = url.substring(iQuestionMark + 1);
        StringTokenizer st = new StringTokenizer(propString, "&;");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            int iIs = propertyString.indexOf("=");
            if (iIs > -1) {
                String property = propertyString.substring(0, iIs);
                String value = propertyString.substring(iIs + 1);
                info.setProperty(property, value);
                continue;
            }
            info.setProperty(propertyString, "");
        }
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(AbstractDriver.class, false);
            try {
                DriverManager.registerDriver(new FBDriver());
            }
            catch (Exception ex) {
                if (log == null) break block2;
                log.error("Could not register with driver manager", ex);
            }
        }
    }
}

