/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBCachedFetcher
implements FBFetcher {
    private final boolean forwardOnly;
    private Object[] rowsArray;
    private int rowNum = 0;
    private int fetchSize;
    private final FBObjectListener.FetcherListener fetcherListener;

    FBCachedFetcher(GDSHelper gdsHelper, int fetchSize, int maxRows, AbstractIscStmtHandle stmt_handle, FBObjectListener.FetcherListener fetcherListener, boolean forwardOnly) throws SQLException {
        this.fetcherListener = fetcherListener;
        this.forwardOnly = forwardOnly;
        ArrayList<byte[][][]> rowsSets = new ArrayList<byte[][][]>(100);
        XSQLVAR[] xsqlvars = stmt_handle.getOutSqlda().sqlvar;
        boolean[] isBlob = new boolean[xsqlvars.length];
        boolean hasBlobs = FBCachedFetcher.determineBlobs(xsqlvars, isBlob);
        int rowsCount = 0;
        try {
            if (fetchSize == 0) {
                fetchSize = 400;
            }
            this.fetchSize = fetchSize;
            if (!stmt_handle.isAllRowsFetched() && stmt_handle.size() == 0) {
                do {
                    if (maxRows != 0 && fetchSize > maxRows - rowsCount) {
                        fetchSize = maxRows - rowsCount;
                    }
                    gdsHelper.fetch(stmt_handle, fetchSize);
                    int fetchedRowCount = stmt_handle.size();
                    if (fetchedRowCount <= 0) continue;
                    Object rows = stmt_handle.getRows();
                    if (((byte[][][])rows).length > fetchedRowCount) {
                        byte[][][] tempRows = new byte[fetchedRowCount][][];
                        System.arraycopy(rows, 0, tempRows, 0, fetchedRowCount);
                        rows = tempRows;
                    }
                    rowsSets.add((byte[][][])rows);
                    rowsCount += fetchedRowCount;
                    stmt_handle.removeRows();
                } while (!stmt_handle.isAllRowsFetched() && (maxRows == 0 || rowsCount < maxRows));
                int rowCount = 0;
                this.rowsArray = new Object[rowsCount];
                for (int i = 0; i < rowsSets.size(); ++i) {
                    Object[] oneSet = (Object[])rowsSets.get(i);
                    int toCopy = Math.min(oneSet.length, rowsCount - rowCount);
                    System.arraycopy(oneSet, 0, this.rowsArray, rowCount, toCopy);
                    rowCount += toCopy;
                }
                rowsSets.clear();
            } else {
                this.rowsArray = (Object[])stmt_handle.getRows();
                stmt_handle.removeRows();
            }
            if (hasBlobs) {
                this.cacheBlobs(gdsHelper, xsqlvars, isBlob);
            }
            gdsHelper.closeStatement(stmt_handle, false);
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    FBCachedFetcher(ArrayList rows, FBObjectListener.FetcherListener fetcherListener, XSQLVAR[] xsqlvars, GDSHelper gdsHelper, boolean retrieveBlobs) throws SQLException {
        boolean[] isBlob;
        boolean hasBlobs;
        assert (retrieveBlobs && xsqlvars != null && gdsHelper != null || !retrieveBlobs) : "Need non-null xsqlvars and gdsHelper for retrieving blobs";
        this.rowsArray = rows.toArray();
        this.fetcherListener = fetcherListener;
        this.forwardOnly = false;
        if (retrieveBlobs && (hasBlobs = FBCachedFetcher.determineBlobs(xsqlvars, isBlob = new boolean[xsqlvars.length]))) {
            this.cacheBlobs(gdsHelper, xsqlvars, isBlob);
        }
    }

    private static boolean determineBlobs(XSQLVAR[] xsqlvars, boolean[] isBlob) {
        assert (xsqlvars.length == isBlob.length) : "length of isBlob should be equal to length of xsqlvars";
        boolean hasBlobs = false;
        for (int i = 0; i < xsqlvars.length; ++i) {
            boolean bl = isBlob[i] = FBField.isType(xsqlvars[i], 2004) || FBField.isType(xsqlvars[i], -2) || FBField.isType(xsqlvars[i], -1);
            if (!isBlob[i]) continue;
            hasBlobs = true;
        }
        return hasBlobs;
    }

    private void cacheBlobs(GDSHelper gdsHelper, XSQLVAR[] xsqlvars, boolean[] isBlob) throws SQLException {
        for (int i = 0; i < this.rowsArray.length; ++i) {
            byte[][] localRow = (byte[][])this.rowsArray[i];
            for (int j = 0; j < localRow.length; ++j) {
                if (!isBlob[j] || localRow[j] == null) continue;
                final byte[] tempData = localRow[j];
                FieldDataProvider dataProvider = new FieldDataProvider(){

                    @Override
                    public byte[] getFieldData() {
                        return tempData;
                    }

                    @Override
                    public void setFieldData(byte[] data) {
                        throw new UnsupportedOperationException();
                    }
                };
                FBFlushableField blob = (FBFlushableField)((Object)FBField.createField(xsqlvars[j], dataProvider, gdsHelper, false));
                localRow[j] = blob.getCachedData();
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        ++this.rowNum;
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = this.rowsArray.length + 1;
            return false;
        }
        this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("This operation is not supported on a TYPE_FORWARD_ONLY result set");
        }
        if (this.isEmpty()) {
            return false;
        }
        --this.rowNum;
        if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = 0;
            return false;
        }
        this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("This operation is not supported on a TYPE_FORWARD_ONLY result set");
        }
        return this.absolute(row, false);
    }

    private boolean absolute(int row, boolean internal) throws SQLException {
        if (this.forwardOnly && !internal) {
            throw new FBDriverNotCapableException("This operation is not supported on a TYPE_FORWARD_ONLY result set");
        }
        if (row < 0) {
            row = this.rowsArray.length + row + 1;
        }
        if (this.isEmpty()) {
            return false;
        }
        this.rowNum = row;
        if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = 0;
            return false;
        }
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = this.rowsArray.length + 1;
            return false;
        }
        this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        return true;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("This operation is not supported on a TYPE_FORWARD_ONLY result set");
        }
        return this.absolute(1, true);
    }

    @Override
    public boolean last() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("This operation is not supported on a TYPE_FORWARD_ONLY result set");
        }
        return this.absolute(-1, true);
    }

    @Override
    public boolean relative(int row) throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("This operation is not supported on a TYPE_FORWARD_ONLY result set");
        }
        return this.absolute(this.rowNum + row, true);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.first();
        this.previous();
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    @Override
    public void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        this.rowsArray = new Object[0];
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public boolean isEmpty() {
        return this.rowsArray == null || this.rowsArray.length == 0;
    }

    @Override
    public boolean isBeforeFirst() {
        return !this.isEmpty() && this.rowNum < 1;
    }

    @Override
    public boolean isFirst() {
        return this.rowNum == 1;
    }

    @Override
    public boolean isLast() {
        return this.rowsArray != null && this.rowNum == this.rowsArray.length;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowNum > this.rowsArray.length;
    }

    @Override
    public void deleteRow() throws SQLException {
        Object[] newRows = new Object[this.rowsArray.length - 1];
        System.arraycopy(this.rowsArray, 0, newRows, 0, this.rowNum - 1);
        if (this.rowNum < this.rowsArray.length) {
            System.arraycopy(this.rowsArray, this.rowNum, newRows, this.rowNum - 1, this.rowsArray.length - this.rowNum);
        }
        this.rowsArray = newRows;
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
        } else if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
        } else {
            this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        }
    }

    @Override
    public void insertRow(byte[][] data) throws SQLException {
        Object[] newRows = new Object[this.rowsArray.length + 1];
        if (this.rowNum == 0) {
            ++this.rowNum;
        }
        System.arraycopy(this.rowsArray, 0, newRows, 0, this.rowNum - 1);
        System.arraycopy(this.rowsArray, this.rowNum - 1, newRows, this.rowNum, this.rowsArray.length - this.rowNum + 1);
        newRows[this.rowNum - 1] = data;
        this.rowsArray = newRows;
        if (this.isAfterLast() || this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
        } else {
            this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        }
    }

    @Override
    public void updateRow(byte[][] data) throws SQLException {
        if (!this.isAfterLast() && !this.isBeforeFirst()) {
            this.rowsArray[this.rowNum - 1] = data;
            this.fetcherListener.rowChanged(this, data);
        }
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }
}

