/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.repository;

import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppModel;
import org.flowable.app.engine.impl.deployer.AppDeploymentManager;
import org.flowable.app.engine.impl.persistence.entity.deploy.AppDefinitionCacheEntry;
import org.flowable.app.engine.impl.util.CommandContextUtil;

public class AppDefinitionUtil {
    public static AppDefinition getAppDefinition(String appDefinitionId) {
        AppDeploymentManager deploymentManager = CommandContextUtil.getAppEngineConfiguration().getDeploymentManager();
        AppDefinitionCacheEntry cacheEntry = (AppDefinitionCacheEntry)deploymentManager.getAppDefinitionCache().get(appDefinitionId);
        return AppDefinitionUtil.getAppDefinition(appDefinitionId, deploymentManager, cacheEntry);
    }

    protected static AppDefinition getAppDefinition(String appDefinitionId, AppDeploymentManager deploymentManager, AppDefinitionCacheEntry cacheEntry) {
        if (cacheEntry != null) {
            return cacheEntry.getAppDefinition();
        }
        return deploymentManager.findDeployedAppDefinitionById(appDefinitionId);
    }

    public static AppModel getAppModel(String appDefinitionId) {
        AppDeploymentManager deploymentManager = CommandContextUtil.getAppEngineConfiguration().getDeploymentManager();
        AppDefinitionCacheEntry cacheEntry = (AppDefinitionCacheEntry)deploymentManager.getAppDefinitionCache().get(appDefinitionId);
        if (cacheEntry != null) {
            return cacheEntry.getAppModel();
        }
        deploymentManager.findDeployedAppDefinitionById(appDefinitionId);
        return ((AppDefinitionCacheEntry)deploymentManager.getAppDefinitionCache().get(appDefinitionId)).getAppModel();
    }
}

