/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.ReactivateEventListener;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;

public abstract class BaseCmmnXmlConverter {
    public abstract String getXMLElementName();

    public abstract boolean hasChildElements();

    public BaseElement convertToCmmnModel(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        BaseElement baseElement = this.convert(xtr, conversionHelper);
        if (baseElement != null) {
            baseElement.setId(xtr.getAttributeValue(null, "id"));
            CmmnXmlUtil.addXMLLocation(baseElement, xtr);
            if (baseElement instanceof CmmnElement) {
                CmmnElement cmmnElement = (CmmnElement)baseElement;
                conversionHelper.setCurrentCmmnElement(cmmnElement);
            }
            if (baseElement instanceof Criterion) {
                Criterion criterion = (Criterion)baseElement;
                conversionHelper.getCmmnModel().addCriterion(criterion.getId(), criterion);
            }
            if (baseElement instanceof ReactivateEventListener) {
                if (conversionHelper.getCurrentCase().getReactivateEventListener() != null) {
                    throw new FlowableIllegalArgumentException("There can only be one reactivation listener on a case model, not multiple ones. Use a start form on the listener, if there are several options on how to reactivate a case and use conditions to handle the different options on reactivation.");
                }
                conversionHelper.getCurrentCase().setReactivateEventListener((ReactivateEventListener)baseElement);
            }
        }
        return baseElement;
    }

    protected abstract BaseElement convert(XMLStreamReader var1, ConversionHelper var2);

    protected void elementEnd(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        if (this.hasChildElements()) {
            conversionHelper.removeCurrentCmmnElement();
        }
    }
}

