/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsXmlConverter
extends BaseCmmnXmlConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefinitionsXmlConverter.class);
    private static final String XSD_DATETIME_FORMAT = "yyyy-MM-dd'T'HH':'mm':'ss";

    @Override
    public String getXMLElementName() {
        return "definitions";
    }

    @Override
    public boolean hasChildElements() {
        return false;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        int i;
        CmmnModel model = conversionHelper.getCmmnModel();
        model.setId(xtr.getAttributeValue(null, "id"));
        model.setName(xtr.getAttributeValue(null, "name"));
        model.setExpressionLanguage(xtr.getAttributeValue(null, "expressionLanguage"));
        model.setExporter(xtr.getAttributeValue(null, "exporter"));
        model.setExporterVersion(xtr.getAttributeValue(null, "exporterVersion"));
        model.setAuthor(xtr.getAttributeValue(null, "author"));
        model.setTargetNamespace(xtr.getAttributeValue(null, "targetNamespace"));
        String creationDateString = xtr.getAttributeValue(null, "creationDate");
        if (StringUtils.isNotEmpty((CharSequence)creationDateString)) {
            try {
                Date creationDate = new SimpleDateFormat(XSD_DATETIME_FORMAT).parse(creationDateString);
                model.setCreationDate(creationDate);
            }
            catch (ParseException e) {
                LOGGER.warn("Ignoring creationDate attribute: invalid date format", (Throwable)e);
            }
        }
        for (i = 0; i < xtr.getNamespaceCount(); ++i) {
            String prefix = xtr.getNamespacePrefix(i);
            if (!StringUtils.isNotEmpty((CharSequence)prefix)) continue;
            model.addNamespace(prefix, xtr.getNamespaceURI(i));
        }
        for (i = 0; i < xtr.getAttributeCount(); ++i) {
            ExtensionAttribute extensionAttribute = new ExtensionAttribute();
            extensionAttribute.setName(xtr.getAttributeLocalName(i));
            extensionAttribute.setValue(xtr.getAttributeValue(i));
            String namespace = xtr.getAttributeNamespace(i);
            if (!model.getNamespaces().containsValue(namespace)) continue;
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                extensionAttribute.setNamespace(namespace);
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
            }
            model.addDefinitionsAttribute(extensionAttribute);
        }
        return null;
    }

    @Override
    protected void elementEnd(XMLStreamReader xtr, ConversionHelper conversionHelper) {
    }
}

