/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceBuilderImpl;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.ChildTask;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseTaskActivityBehavior
extends ChildTaskActivityBehavior
implements PlanItemActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseTaskActivityBehavior.class);
    protected Expression caseRefExpression;
    protected String caseRef;
    protected Boolean fallbackToDefaultTenant;
    protected boolean sameDeployment;
    protected CaseTask caseTask;

    public CaseTaskActivityBehavior(Expression caseRefExpression, CaseTask caseTask) {
        super(caseTask.isBlocking(), caseTask.getBlockingExpression(), caseTask.getInParameters(), caseTask.getOutParameters());
        this.caseRefExpression = caseRefExpression;
        this.caseRef = caseTask.getCaseRef();
        this.fallbackToDefaultTenant = caseTask.getFallbackToDefaultTenant();
        this.sameDeployment = caseTask.isSameDeployment();
        this.caseTask = caseTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ChildTaskActivityBehavior.VariableInfo variableInfo) {
        Expression expression;
        String idVariableName;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CaseInstanceHelper caseInstanceHelper = CommandContextUtil.getCaseInstanceHelper(commandContext);
        String caseDefinitionKey = null;
        if (this.caseRefExpression != null) {
            caseDefinitionKey = this.caseRefExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
        } else if (StringUtils.isNotEmpty((CharSequence)this.caseRef)) {
            caseDefinitionKey = this.caseRef;
        }
        if (StringUtils.isEmpty((CharSequence)caseDefinitionKey)) {
            throw new FlowableException("Could not start case instance: no case reference defined");
        }
        CaseInstanceBuilder caseInstanceBuilder = new CaseInstanceBuilderImpl().caseDefinitionKey(caseDefinitionKey);
        if (StringUtils.isNotEmpty((CharSequence)planItemInstanceEntity.getTenantId())) {
            caseInstanceBuilder.tenantId(planItemInstanceEntity.getTenantId());
            caseInstanceBuilder.overrideCaseDefinitionTenantId(planItemInstanceEntity.getTenantId());
        }
        caseInstanceBuilder.parentId(planItemInstanceEntity.getCaseInstanceId());
        if (this.fallbackToDefaultTenant != null && this.fallbackToDefaultTenant.booleanValue()) {
            caseInstanceBuilder.fallbackToDefaultTenant();
        }
        HashMap<String, Object> finalVariableMap = new HashMap<String, Object>();
        this.handleInParameters(planItemInstanceEntity, cmmnEngineConfiguration, finalVariableMap, cmmnEngineConfiguration.getExpressionManager());
        Map variablesFromFormSubmission = null;
        if (variableInfo != null) {
            if (variableInfo.formInfo != null) {
                FormService formService = CommandContextUtil.getFormService(commandContext);
                if (formService == null) {
                    throw new FlowableIllegalStateException("Form engine is not initialized");
                }
                variablesFromFormSubmission = formService.getVariablesFromFormSubmission(variableInfo.formInfo, variableInfo.formVariables, variableInfo.formOutcome);
                finalVariableMap.putAll(variablesFromFormSubmission);
            }
            if (variableInfo.variables != null && !variableInfo.variables.isEmpty()) {
                finalVariableMap.putAll(variableInfo.variables);
            }
        }
        caseInstanceBuilder.businessKey(this.getBusinessKey(cmmnEngineConfiguration, planItemInstanceEntity, (ChildTask)this.caseTask));
        caseInstanceBuilder.variables(finalVariableMap);
        caseInstanceBuilder.callbackType("cmmn-1.1-to-cmmn-1.1-child-case");
        caseInstanceBuilder.callbackId(planItemInstanceEntity.getId());
        if (this.sameDeployment) {
            caseInstanceBuilder.caseDefinitionParentDeploymentId(CaseDefinitionUtil.getDefinitionDeploymentId(planItemInstanceEntity.getCaseDefinitionId(), cmmnEngineConfiguration));
        }
        CaseInstanceEntity caseInstanceEntity = caseInstanceHelper.startCaseInstance(caseInstanceBuilder);
        if (StringUtils.isNotEmpty((CharSequence)this.caseTask.getCaseInstanceIdVariableName()) && StringUtils.isNotEmpty((CharSequence)(idVariableName = (String)(expression = cmmnEngineConfiguration.getExpressionManager().createExpression(this.caseTask.getCaseInstanceIdVariableName())).getValue((VariableContainer)planItemInstanceEntity)))) {
            planItemInstanceEntity.setVariable(idVariableName, caseInstanceEntity.getId());
        }
        planItemInstanceEntity.setReferenceType("cmmn-1.1-to-cmmn-1.1-child-case");
        planItemInstanceEntity.setReferenceId(caseInstanceEntity.getId());
        if (variablesFromFormSubmission != null && !variablesFromFormSubmission.isEmpty()) {
            cmmnEngineConfiguration.getFormFieldHandler().handleFormFieldsOnSubmit(variableInfo.formInfo, null, null, caseInstanceEntity.getId(), "cmmn", variablesFromFormSubmission, caseInstanceEntity.getTenantId());
        }
        if (!this.evaluateIsBlocking(planItemInstanceEntity)) {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableIllegalStateException("Can only trigger a plan item that is in the ACTIVE state");
        }
        if (planItemInstance.getReferenceId() == null) {
            throw new FlowableIllegalStateException("Cannot trigger case task plan item instance : no reference id set");
        }
        if (!"cmmn-1.1-to-cmmn-1.1-child-case".equals(planItemInstance.getReferenceType())) {
            throw new FlowableIllegalStateException("Cannot trigger case task plan item instance : reference type '" + planItemInstance.getReferenceType() + "' not supported");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CaseInstanceEntityManager caseInstanceEntityManager = cmmnEngineConfiguration.getCaseInstanceEntityManager();
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)caseInstanceEntityManager.findById(planItemInstance.getCaseInstanceId());
        this.handleOutParameters(planItemInstance, caseInstance, cmmnEngineConfiguration.getCmmnRuntimeService(), cmmnEngineConfiguration);
        CommandContextUtil.getAgenda(commandContext).planManualTerminateCaseInstanceOperation(planItemInstance.getReferenceId());
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("active".equals(planItemInstance.getState()) && ("terminate".equals(transition) || "exit".equals(transition))) {
            CommandContextUtil.getAgenda(commandContext).planManualTerminateCaseInstanceOperation(planItemInstance.getReferenceId());
        }
    }

    protected Object resolveExpression(CmmnEngineConfiguration cmmnEngineConfiguration, String executionId, String expressionString) {
        CaseInstanceEntityManager caseInstanceEntityManager = cmmnEngineConfiguration.getCaseInstanceEntityManager();
        Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(expressionString);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstanceEntityManager.findById(executionId);
        return expression.getValue((VariableContainer)caseInstanceEntity);
    }

    @Override
    public void deleteChildEntity(CommandContext commandContext, DelegatePlanItemInstance delegatePlanItemInstance, boolean cascade) {
        if ("cmmn-1.1-to-cmmn-1.1-child-case".equals(delegatePlanItemInstance.getReferenceType())) {
            CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)caseInstanceEntityManager.findById(delegatePlanItemInstance.getReferenceId());
            if (caseInstance != null && !caseInstance.isDeleted()) {
                caseInstanceEntityManager.delete(caseInstance.getId(), cascade, null);
            }
        } else {
            throw new FlowableException("Can only delete a child entity for a plan item with reference type cmmn-1.1-to-cmmn-1.1-child-case");
        }
    }

    protected void handleOutParameters(DelegatePlanItemInstance planItemInstance, CaseInstanceEntity caseInstance, CmmnRuntimeService cmmnRuntimeService, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (this.outParameters == null) {
            return;
        }
        for (IOParameter outParameter : this.outParameters) {
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getTarget())) {
                variableName = outParameter.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getTargetExpression())) {
                Object variableNameValue = this.resolveExpression(cmmnEngineConfiguration, planItemInstance.getReferenceId(), outParameter.getTargetExpression());
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("Out parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)outParameter.getTargetExpression());
                }
            }
            Object variableValue = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getSourceExpression())) {
                variableValue = this.resolveExpression(cmmnEngineConfiguration, planItemInstance.getReferenceId(), outParameter.getSourceExpression());
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getSource())) {
                variableValue = cmmnRuntimeService.getVariable(planItemInstance.getReferenceId(), outParameter.getSource());
            }
            caseInstance.setVariable(variableName, variableValue);
        }
    }
}

