/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CompleteTaskWithFormCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionId;
    protected String outcome;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected boolean localScope;

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables) {
        super(taskId);
        this.formDefinitionId = formDefinitionId;
        this.outcome = outcome;
        this.variables = variables;
    }

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, boolean localScope) {
        this(taskId, formDefinitionId, outcome, variables);
        this.localScope = localScope;
    }

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, formDefinitionId, outcome, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        FormService formService = CommandContextUtil.getFormService(commandContext);
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService(commandContext);
        FormInfo formInfo = formRepositoryService.getFormModelById(this.formDefinitionId);
        if (formInfo != null) {
            FormFieldHandler formFieldHandler = cmmnEngineConfiguration.getFormFieldHandler();
            if (this.isFormFieldValidationEnabled(task)) {
                formService.validateFormFields(formInfo, this.variables);
            }
            Map taskVariables = formService.getVariablesFromFormSubmission(formInfo, this.variables, this.outcome);
            if (task.getProcessInstanceId() != null && this.variables != null) {
                formService.saveFormInstance(this.variables, formInfo, task.getId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTenantId(), this.outcome);
            } else if (task.getScopeId() != null && this.variables != null) {
                formService.saveFormInstanceWithScopeId(this.variables, formInfo, task.getId(), task.getScopeId(), task.getScopeType(), task.getScopeDefinitionId(), task.getTenantId(), this.outcome);
            }
            formFieldHandler.handleFormFieldsOnSubmit(formInfo, task.getId(), null, task.getScopeId(), task.getScopeType(), taskVariables, task.getTenantId());
            this.completeTask(commandContext, task, taskVariables);
        } else {
            this.completeTask(commandContext, task, this.variables);
        }
        return null;
    }

    protected boolean isFormFieldValidationEnabled(TaskEntity task) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        if (cmmnEngineConfiguration.isFormFieldValidationEnabled()) {
            HumanTask humanTask = (HumanTask)CaseDefinitionUtil.getCmmnModel(task.getScopeDefinitionId()).findPlanItemDefinition(task.getTaskDefinitionKey());
            String formFieldValidationExpression = humanTask.getValidateFormFields();
            return TaskHelper.isFormFieldValidationEnabled((VariableContainer)task, cmmnEngineConfiguration, formFieldValidationExpression);
        }
        return false;
    }

    protected void completeTask(CommandContext commandContext, TaskEntity task, Map<String, Object> taskVariables) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        String planItemInstanceId = task.getSubScopeId();
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableException("Could not find plan item instance for task " + this.taskId);
        }
        if (taskVariables != null) {
            if (this.localScope) {
                task.setVariablesLocal(taskVariables);
            } else {
                task.setVariables(taskVariables);
            }
        }
        if (this.transientVariables != null) {
            if (this.localScope) {
                task.setTransientVariablesLocal(this.transientVariables);
            } else {
                task.setTransientVariables(this.transientVariables);
            }
        }
        TaskHelper.logUserTaskCompleted(task, cmmnEngineConfiguration);
        if (cmmnEngineConfiguration.getIdentityLinkInterceptor() != null) {
            cmmnEngineConfiguration.getIdentityLinkInterceptor().handleCompleteTask(task);
        }
        cmmnEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(task, "complete");
        CommandContextUtil.getAgenda(commandContext).planTriggerPlanItemInstanceOperation(planItemInstanceEntity);
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot complete a suspended task";
    }
}

