/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delegate;

import java.util.List;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemFutureJavaDelegate;
import org.flowable.cmmn.api.delegate.PlanItemJavaDelegate;
import org.flowable.cmmn.api.listener.CaseInstanceLifecycleListener;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifecycleListener;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.CmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemFutureJavaDelegateActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemJavaDelegateActivityBehavior;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.FixedValue;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;

public class CmmnClassDelegate
implements CmmnTriggerableActivityBehavior,
TaskListener,
PlanItemInstanceLifecycleListener,
CaseInstanceLifecycleListener {
    protected String sourceState;
    protected String targetState;
    protected String className;
    protected List<FieldExtension> fieldExtensions;
    protected CmmnActivityBehavior activityBehaviorInstance;

    public CmmnClassDelegate(String className, List<FieldExtension> fieldExtensions) {
        this.className = className;
        this.fieldExtensions = fieldExtensions;
    }

    @Override
    public void execute(DelegatePlanItemInstance planItemInstance) {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getCmmnActivityBehavior(this.className);
        }
        this.activityBehaviorInstance.execute(planItemInstance);
    }

    @Override
    public void trigger(DelegatePlanItemInstance planItemInstance) {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getCmmnActivityBehavior(this.className);
        }
        if (!(this.activityBehaviorInstance instanceof CmmnTriggerableActivityBehavior)) {
            throw new FlowableIllegalArgumentException(this.className + " does not implement the " + CmmnTriggerableActivityBehavior.class + " interface");
        }
        ((CmmnTriggerableActivityBehavior)this.activityBehaviorInstance).trigger(planItemInstance);
    }

    protected CmmnActivityBehavior getCmmnActivityBehavior(String className) {
        Object instance = this.instantiate(className);
        CmmnClassDelegate.applyFieldExtensions(this.fieldExtensions, instance, false);
        if (instance instanceof PlanItemJavaDelegate) {
            return new PlanItemJavaDelegateActivityBehavior((PlanItemJavaDelegate)instance);
        }
        if (instance instanceof PlanItemFutureJavaDelegate) {
            return new PlanItemFutureJavaDelegateActivityBehavior((PlanItemFutureJavaDelegate)instance);
        }
        if (instance instanceof CmmnTriggerableActivityBehavior) {
            return (CmmnTriggerableActivityBehavior)instance;
        }
        if (instance instanceof CmmnActivityBehavior) {
            return (CmmnActivityBehavior)instance;
        }
        throw new FlowableIllegalArgumentException(className + " does not implement the " + CmmnActivityBehavior.class + " nor the " + PlanItemJavaDelegate.class + " interface");
    }

    public void notify(DelegateTask delegateTask) {
        TaskListener taskListenerInstance = this.getTaskListenerInstance(delegateTask);
        taskListenerInstance.notify(delegateTask);
    }

    protected TaskListener getTaskListenerInstance(DelegateTask delegateTask) {
        Object delegateInstance = this.instantiate(this.className);
        CmmnClassDelegate.applyFieldExtensions(this.fieldExtensions, delegateTask, false);
        if (delegateInstance instanceof TaskListener) {
            return (TaskListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TaskListener.class);
    }

    public void stateChanged(DelegatePlanItemInstance planItemInstance, String oldState, String newState) {
        PlanItemInstanceLifecycleListener planItemLifeCycleListenerInstance = this.getPlanItemLifeCycleListenerInstance();
        planItemLifeCycleListenerInstance.stateChanged(planItemInstance, oldState, newState);
    }

    public void stateChanged(CaseInstance caseInstance, String oldState, String newState) {
        CaseInstanceLifecycleListener caseLifeCycleListenerInstance = this.getCaseLifeCycleListenerInstance();
        caseLifeCycleListenerInstance.stateChanged(caseInstance, oldState, newState);
    }

    protected PlanItemInstanceLifecycleListener getPlanItemLifeCycleListenerInstance() {
        Object delegateInstance = this.instantiate(this.className);
        CmmnClassDelegate.applyFieldExtensions(this.fieldExtensions, delegateInstance, false);
        if (delegateInstance instanceof PlanItemInstanceLifecycleListener) {
            return (PlanItemInstanceLifecycleListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + PlanItemInstanceLifecycleListener.class);
    }

    protected CaseInstanceLifecycleListener getCaseLifeCycleListenerInstance() {
        Object delegateInstance = this.instantiate(this.className);
        CmmnClassDelegate.applyFieldExtensions(this.fieldExtensions, delegateInstance, false);
        if (delegateInstance instanceof CaseInstanceLifecycleListener) {
            return (CaseInstanceLifecycleListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + CaseInstanceLifecycleListener.class);
    }

    protected Object instantiate(String className) {
        return ReflectUtil.instantiate((String)className);
    }

    public static void applyFieldExtensions(List<FieldExtension> fieldExtensions, Object target, boolean throwExceptionOnMissingField) {
        if (fieldExtensions != null) {
            for (FieldExtension fieldExtension : fieldExtensions) {
                CmmnClassDelegate.applyFieldExtension(fieldExtension, target, throwExceptionOnMissingField);
            }
        }
    }

    protected static void applyFieldExtension(FieldExtension fieldExtension, Object target, boolean throwExceptionOnMissingField) {
        FixedValue value = null;
        if (fieldExtension.getExpression() != null) {
            ExpressionManager expressionManager = CommandContextUtil.getCmmnEngineConfiguration().getExpressionManager();
            value = expressionManager.createExpression(fieldExtension.getExpression());
        } else {
            value = new FixedValue((Object)fieldExtension.getStringValue());
        }
        ReflectUtil.invokeSetterOrField((Object)target, (String)fieldExtension.getFieldName(), (Object)value, (boolean)throwExceptionOnMissingField);
    }

    public String getSourceState() {
        return this.sourceState;
    }

    public void setSourceState(String sourceState) {
        this.sourceState = sourceState;
    }

    public String getTargetState() {
        return this.targetState;
    }

    public void setTargetState(String targetState) {
        this.targetState = targetState;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<FieldExtension> getFieldExtensions() {
        return this.fieldExtensions;
    }

    public void setFieldExtensions(List<FieldExtension> fieldExtensions) {
        this.fieldExtensions = fieldExtensions;
    }

    public CmmnActivityBehavior getActivityBehaviorInstance() {
        return this.activityBehaviorInstance;
    }

    public void setActivityBehaviorInstance(CmmnActivityBehavior activityBehaviorInstance) {
        this.activityBehaviorInstance = activityBehaviorInstance;
    }
}

